/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.tools;

import com.bes.mq.admin.facade.impl.jeemx.tools.MBeanServerConnectionWraper;
import com.bes.mq.admin.facade.impl.jeemx.tools.ProxyFactory;
import com.bes.mq.admin.facade.impl.jeemx.tools.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;

public class MBeanServerConnectionFactory {
    private static Set<MBeanServerConnectionWraper> pool = new HashSet<MBeanServerConnectionWraper>();
    private static ReentrantLock lock = new ReentrantLock();

    private MBeanServerConnectionFactory() {
    }

    public static MBeanServerConnection getMBeanServerConnection(String host, int port, String username, String password) throws Exception {
        return MBeanServerConnectionFactory.getMBeanServerConnection(host, port, username, password, false);
    }

    public static MBeanServerConnection getMBeanServerConnection(String host, int port, String username, String password, boolean isNew) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", host);
        map.put("port", "" + port);
        map.put("username", username);
        map.put("password", password);
        return MBeanServerConnectionFactory.getMBeanServerConnection(map, isNew);
    }

    public static MBeanServerConnection getMBeanServerConnection(Map<String, String> map) throws Exception {
        return MBeanServerConnectionFactory.getMBeanServerConnection(map, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServerConnection getMBeanServerConnection(Map<String, String> map, boolean isNew) throws Exception {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        MBeanServerConnectionFactory.format(map);
        MBeanServerConnectionWraper conn = null;
        try {
            lock.lock();
            conn = MBeanServerConnectionFactory.getMBeanServerConnectionWraper(map);
            if (conn == null) {
                conn = MBeanServerConnectionFactory.createMBeanServerConnectionWraper(map);
                pool.add(conn);
            } else if (isNew) {
                conn = MBeanServerConnectionFactory.createMBeanServerConnectionWraper(map);
                pool.add(conn);
            }
        }
        finally {
            lock.unlock();
        }
        return conn.getSrcConn();
    }

    private static MBeanServerConnectionWraper getMBeanServerConnectionWraper(Map<String, String> map) {
        String host = StringUtil.nvl(map.get("host"));
        String port = StringUtil.nvl(map.get("port"));
        String username = StringUtil.nvl(map.get("username"));
        String password = StringUtil.nvl(map.get("password"));
        for (MBeanServerConnectionWraper c : pool) {
            if (!c.equals(new MBeanServerConnectionWraper(host, Integer.parseInt(port), username, password))) continue;
            return c;
        }
        return null;
    }

    private static MBeanServerConnectionWraper createMBeanServerConnectionWraper(Map<String, String> map) throws Exception {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        MBeanServerConnectionFactory.format(map);
        String host = StringUtil.nvl(map.get("host"));
        String port = StringUtil.nvl(map.get("port"));
        String username = StringUtil.nvl(map.get("username"));
        String password = StringUtil.nvl(map.get("password"));
        JMXConnector con = MBeanServerConnectionFactory.createJMXConnector(map);
        MBeanServerConnectionWraper c = new MBeanServerConnectionWraper(host, Integer.parseInt(port), username, password, con);
        return c;
    }

    private static JMXConnector createJMXConnector(Map<String, String> map) throws Exception {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        MBeanServerConnectionFactory.format(map);
        String host = StringUtil.nvl(map.get("host"));
        String port = StringUtil.nvl(map.get("port"));
        String username = StringUtil.nvl(map.get("username"));
        String password = StringUtil.nvl(map.get("password"));
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] creds = new String[]{username, password};
        env.put("jmx.remote.credentials", creds);
        String urlService = "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jmxrmi";
        JMXServiceURL url = new JMXServiceURL(urlService);
        JMXConnector conn = ProxyFactory.createConnectorProxy(url, env);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll() {
        try {
            MBeanServerConnectionWraper[] wrapers;
            lock.lock();
            for (MBeanServerConnectionWraper c : wrapers = pool.toArray(new MBeanServerConnectionWraper[0])) {
                c.close();
                pool.remove(c);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(MBeanServerConnection conn) {
        try {
            lock.lock();
            for (MBeanServerConnectionWraper c : pool) {
                if (c.getSrcConn() != conn) continue;
                c.close();
                pool.remove(c);
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void format(Map<String, String> map) {
        String host = StringUtil.nvl(map.get("host"));
        String port = StringUtil.nvl(map.get("port"));
        String username = StringUtil.nvl(map.get("username"));
        String password = StringUtil.nvl(map.get("password"));
        if ("".equals(host)) {
            host = "localhost";
        }
        if ("".equals(port)) {
            port = "1901";
        }
        if ("".equals(username)) {
            username = "admin";
        }
        if ("".equals(password)) {
            password = "admin";
        }
        map.put("host", host);
        map.put("port", port);
        map.put("username", username);
        map.put("password", password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(Map<String, String> map) throws Exception {
        try {
            lock.lock();
            if (map == null) {
                map = new HashMap<String, String>();
            }
            MBeanServerConnectionFactory.format(map);
            MBeanServerConnectionWraper conn = MBeanServerConnectionFactory.getMBeanServerConnectionWraper(map);
            if (conn != null) {
                conn.close();
                pool.remove(conn);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

