/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.tools;

import com.bes.mq.admin.facade.impl.jeemx.tools.JMXConnectorHandler;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MBeanServerConnectionHandler
implements InvocationHandler {
    private JMXConnectorHandler connector;
    private MBeanServerConnection delegate;
    private Set<ObjectKey> listenerObjects = new HashSet<ObjectKey>();
    private final Object key = new Object();
    static Set<String> includeMethods = new HashSet<String>(Arrays.asList("addNotificationListener", "removeNotificationListener"));

    public MBeanServerConnectionHandler(JMXConnectorHandler conn) {
        this.connector = conn;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        boolean success = false;
        try {
            this.connector.preConnectionInvoke();
            this.delegate = this.delegate == null ? this.connector.getCurrentMBeanServerConnection() : this.delegate;
            Object result = method.invoke((Object)this.delegate, args);
            success = true;
            Object object = result;
            return object;
        }
        catch (Throwable ex) {
            if (ex instanceof IOException || ex.getCause() instanceof IOException) {
                this.connector.recreate();
                this.delegate = this.connector.getCurrentMBeanServerConnection();
                try {
                    Object result = method.invoke((Object)this.delegate, args);
                    success = true;
                    Object object = result;
                    return object;
                }
                catch (Throwable retryEx) {
                    throw retryEx instanceof InvocationTargetException ? retryEx.getCause() : retryEx;
                }
            }
            throw ex instanceof InvocationTargetException ? ex.getCause() : ex;
        }
        finally {
            this.connector.postConnectionInvoke();
            if (success) {
                this.execute(proxy, method, args);
            }
            if (this.listenerObjects.isEmpty()) {
                this.delegate = null;
                this.connector.finish();
            }
        }
    }

    public void execute(Object proxy, Method method, Object[] args) {
        if (includeMethods.contains(method.getName())) {
            try {
                Method mth = MBeanServerConnectionHandler.class.getMethod(method.getName(), method.getParameterTypes());
                mth.invoke((Object)this, args);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.listenerObjects.add(new ObjectKey(name, listener));
        this.connector.register(this);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.listenerObjects.add(new ObjectKey(name, listener));
        this.connector.register(this);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.listenerObjects.remove(new ObjectKey(name, listener));
        if (this.listenerObjects.isEmpty()) {
            this.connector.unregister(this);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.listenerObjects.remove(new ObjectKey(name, listener));
        if (this.listenerObjects.isEmpty()) {
            this.connector.unregister(this);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.listenerObjects.remove(new ObjectKey(name, listener));
        if (this.listenerObjects.isEmpty()) {
            this.connector.unregister(this);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.listenerObjects.remove(new ObjectKey(name, listener));
        if (this.listenerObjects.isEmpty()) {
            this.connector.unregister(this);
        }
    }

    public int hashCode() {
        int hash = 39;
        if (this.key != null) {
            hash += 7 * this.key.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MBeanServerConnectionHandler) {
            MBeanServerConnectionHandler other = (MBeanServerConnectionHandler)obj;
            if (this.key == null && other.key == null) {
                return true;
            }
            if (this.key != null && other.key != null) {
                return this.key.equals(other.key);
            }
            return false;
        }
        return false;
    }

    static class ObjectKey {
        ObjectName objectName;
        Object listener;

        public ObjectKey(ObjectName o, Object l) {
            this.objectName = o;
            this.listener = l;
        }

        public int hashCode() {
            int hash = 39;
            if (this.objectName != null) {
                hash += 7 * this.objectName.hashCode();
            }
            if (this.listener != null) {
                hash += 7 * this.listener.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ObjectKey) {
                ObjectKey other = (ObjectKey)obj;
                if (this.objectName != null || other.objectName != null) {
                    if (this.objectName != null && other.objectName != null) {
                        if (!this.objectName.equals(other.objectName)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (this.listener == null && other.listener == null) {
                    return true;
                }
                if (this.listener != null && other.listener != null) {
                    return this.listener.equals(other.listener);
                }
                return false;
            }
            return false;
        }
    }
}

