/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.tools;

import com.bes.mq.admin.facade.impl.jeemx.JEEMXUtils;
import com.bes.mq.admin.facade.impl.jeemx.tools.JMXConnectorHandler;
import com.bes.mq.admin.facade.impl.jeemx.tools.MBeanServerConnectionHandler;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;

public class ProxyFactory {
    private static final String PER_CALL_PER_CONNECTOR = "com.bes.mq.jmx.perCallPerConnector";
    private static final boolean isPerCallPerConnector = Boolean.valueOf(System.getProperty("com.bes.mq.jmx.perCallPerConnector", "false"));
    private static final Integer TIMEOUT_RMI = Integer.valueOf(System.getProperty("timeout.connect.rmi", "10000"));
    private static final Logger logger = JEEMXUtils.getLogger();

    private ProxyFactory() {
    }

    public static MBeanServerConnection createProxy(JMXConnectorHandler conn) {
        MBeanServerConnectionHandler handler = new MBeanServerConnectionHandler(conn);
        return (MBeanServerConnection)Proxy.newProxyInstance(MBeanServerConnectionHandler.class.getClassLoader(), new Class[]{MBeanServerConnection.class}, (InvocationHandler)handler);
    }

    public static JMXConnector createConnectorProxy(JMXServiceURL url, Map env) throws IOException {
        HashMap<String, Object> params = null;
        params = env == null ? new HashMap<String, Object>() : env;
        params.put("jmx.remote.default.class.loader", JMXConnectorHandler.class.getClassLoader());
        params.put("jmx.remote.x.client.connection.check.period", 0);
        JMXConnector connector = JMXConnectorFactory.connect(url, params);
        if (isPerCallPerConnector) {
            JMXConnectorHandler handler = new JMXConnectorHandler(connector, url, params);
            return (JMXConnector)Proxy.newProxyInstance(JMXConnectorHandler.class.getClassLoader(), new Class[]{JMXConnector.class}, (InvocationHandler)handler);
        }
        return connector;
    }

    static {
        try {
            RMISocketFactory socketFactory = RMIMasterSocketFactory.getSocketFactory();
            if (socketFactory == null) {
                RMISocketFactory.setSocketFactory((RMISocketFactory)new RMIMasterSocketFactory(){

                    public Socket createSocket(String host, int port) throws IOException {
                        Socket socket = new Socket();
                        socket.connect(new InetSocketAddress(host, port), TIMEOUT_RMI);
                        return socket;
                    }
                });
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "create rmi socket fail", e);
        }
    }
}

