/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.facade.impl.jeemx.usage;

import com.bes.mq.admin.facade.api.Utils;
import com.bes.mq.admin.facade.api.usage.UsageFacade;
import com.bes.mq.admin.facade.api.usage.pojo.SystemUsagePojo;
import com.bes.mq.admin.facade.impl.jeemx.BaseFacade;
import com.bes.mq.admin.facade.impl.jeemx.JEEMXHelper;
import com.bes.mq.jeemx.config.intf.MemoryUsage;
import com.bes.mq.jeemx.config.intf.StoreUsage;
import com.bes.mq.jeemx.config.intf.SystemUsage;
import com.bes.mq.jeemx.config.intf.TempUsage;

public class UsageFacadeImpl
extends BaseFacade
implements UsageFacade {
    public UsageFacadeImpl(JEEMXHelper jeemxHelper) {
        super(jeemxHelper);
    }

    @Override
    public void setSystemUsage(SystemUsagePojo pojo) throws Exception {
        SystemUsage systemUsages = this.jeemxHelper.getSystemUsage();
        MemoryUsage memoryUsage = systemUsages.getMemoryUsage();
        StoreUsage storeUsage = systemUsages.getStoreUsage();
        TempUsage tempUsage = systemUsages.getTempUsage();
        memoryUsage.setLimit(String.valueOf(pojo.getMemoryLimit()));
        storeUsage.setLimit(String.valueOf(pojo.getStorageSpaceLimit()));
        tempUsage.setLimit(String.valueOf(pojo.getTempStorageSpaceLimit()));
        memoryUsage.setSplitSystemUsageForProducersConsumers(String.valueOf(pojo.isEnableSplitMemory()));
        memoryUsage.setProducerSystemUsagePortion(String.valueOf(pojo.getProducerPercent()));
        memoryUsage.setConsumerSystemUsagePortion(String.valueOf(pojo.getConsumerPercent()));
    }

    @Override
    public void disableSplitMemory() throws Exception {
        MemoryUsage memoryUsages = this.jeemxHelper.getSystemUsage().getMemoryUsage();
        memoryUsages.setSplitSystemUsageForProducersConsumers("false");
    }

    @Override
    public void enableSplitMemory(int producerPercent, int consumerPercent) throws Exception {
        MemoryUsage memoryUsages = this.jeemxHelper.getSystemUsage().getMemoryUsage();
        memoryUsages.setSplitSystemUsageForProducersConsumers("true");
        memoryUsages.setProducerSystemUsagePortion(String.valueOf(producerPercent));
        memoryUsages.setConsumerSystemUsagePortion(String.valueOf(consumerPercent));
    }

    @Override
    public SystemUsagePojo getSystemUsage() throws Exception {
        SystemUsage systemUsage = this.jeemxHelper.getSystemUsage();
        MemoryUsage memoryUsage = systemUsage.getMemoryUsage();
        StoreUsage storeUsage = systemUsage.getStoreUsage();
        TempUsage tempUsage = systemUsage.getTempUsage();
        SystemUsagePojo pojo = new SystemUsagePojo();
        pojo.setMemoryLimit(Utils.toInt(memoryUsage.getLimit()));
        pojo.setStorageSpaceLimit(Utils.toInt(storeUsage.getLimit()));
        pojo.setTempStorageSpaceLimit(Utils.toInt(tempUsage.getLimit()));
        pojo.setEnableSplitMemory(Utils.toBoolean(memoryUsage.getSplitSystemUsageForProducersConsumers()));
        pojo.setProducerPercent(Utils.toInt(memoryUsage.getProducerSystemUsagePortion()));
        pojo.setConsumerPercent(Utils.toInt(memoryUsage.getConsumerSystemUsagePortion()));
        return pojo;
    }

    @Override
    public void updateSystemUsed(SystemUsagePojo pojo) throws Exception {
        MemoryUsage memoryUsage = this.jeemxHelper.getSystemUsage().getMemoryUsage();
        StoreUsage storeUsage = this.jeemxHelper.getSystemUsage().getStoreUsage();
        TempUsage tempUsage = this.jeemxHelper.getSystemUsage().getTempUsage();
        if (memoryUsage == null || storeUsage == null || tempUsage == null) {
            return;
        }
        memoryUsage.setLimit(String.valueOf(pojo.getMemoryLimit()));
        memoryUsage.setSplitSystemUsageForProducersConsumers(String.valueOf(pojo.isEnableSplitMemory()));
        memoryUsage.setProducerSystemUsagePortion(String.valueOf(pojo.getProducerPercent()));
        memoryUsage.setConsumerSystemUsagePortion(String.valueOf(pojo.getConsumerPercent()));
        storeUsage.setLimit(String.valueOf(pojo.getStorageSpaceLimit()));
        tempUsage.setLimit(String.valueOf(pojo.getTempStorageSpaceLimit()));
    }

    @Override
    public int getPolicyMemoryLimit(int memoryLimit) {
        return this.jeemxHelper.getBroker().getPolicyMemoryLimit(memoryLimit);
    }
}

