/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.admin.node.impl.ssh;

import com.bes.mq.admin.node.NodeFacade;
import com.bes.mq.admin.node.impl.ssh.SSHExec;
import com.bes.mq.console.brokers.util.Broker;
import java.util.logging.Logger;

public class SSHNodeFacade
implements NodeFacade {
    private static final Logger LOG = Logger.getLogger("SSHNodeFacade");

    @Override
    public String createBroker(Broker broker) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("create --broker").append(" --passport ").append(broker.getPassport());
        if (broker.getUsername() != null && !broker.getUsername().isEmpty()) {
            sb.append(" --admin-user ").append(broker.getUsername());
        }
        if (broker.getPassword() != null && !broker.getPassword().isEmpty()) {
            sb.append(" --admin-password ").append(broker.getPassword());
        }
        if (broker.getBrokerDir() != null && !broker.getBrokerDir().isEmpty()) {
            sb.append(" --broker-dir ").append(broker.getBrokerDir());
        }
        if (broker.getPort() != null && !broker.getPort().isEmpty()) {
            sb.append(" --admin-port ").append(broker.getPort());
        }
        if (broker.getTcpPort() != null && !broker.getTcpPort().isEmpty()) {
            sb.append(" --tcp-port ").append(broker.getTcpPort());
        }
        if (broker.getJndiPort() != null && !broker.getJndiPort().isEmpty()) {
            sb.append(" --jndi-port ").append(broker.getJndiPort());
        }
        sb.append(" ").append(broker.getBrokerName());
        String command = this.concatWithMqAdmin(broker, sb.toString());
        SSHExec exec = this.exec(broker, command);
        return this.handleResult(exec);
    }

    @Override
    public String startBroker(Broker broker) throws Exception {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        sb.append("start --broker").append(" --passport ").append(broker.getPassport());
        sb2.append("start --broker").append(" --passport ").append("******");
        if (broker.getBrokerDir() != null && !broker.getBrokerDir().isEmpty()) {
            sb.append(" --broker-dir ").append(broker.getBrokerDir());
            sb2.append(" --broker-dir ").append(broker.getBrokerDir());
        }
        sb.append(" ").append(broker.getBrokerName());
        sb2.append(" ").append(broker.getBrokerName());
        String command = this.concatWithMqAdmin(broker, sb.toString());
        LOG.info("Exec command: " + command);
        SSHExec exec = this.exec(broker, command);
        return this.handleResult(exec);
    }

    @Override
    public String restartBroker(Broker broker) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("restart --broker").append(" --passport ").append(broker.getPassport());
        if (broker.getBrokerDir() != null && !broker.getBrokerDir().isEmpty()) {
            sb.append(" --broker-dir ").append(broker.getBrokerDir());
        }
        sb.append(" ").append(broker.getBrokerName());
        String command = this.concatWithMqAdmin(broker, sb.toString());
        SSHExec exec = this.exec(broker, command);
        return this.handleResult(exec);
    }

    @Override
    public String stopBroker(Broker broker, boolean force, boolean kill) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("stop --broker").append(" --passport ").append(broker.getPassport());
        if (force) {
            sb.append(" --force true");
        }
        if (kill) {
            sb.append(" --kill true");
        }
        if (broker.getBrokerDir() != null && !broker.getBrokerDir().isEmpty()) {
            sb.append(" --broker-dir ").append(broker.getBrokerDir());
        }
        sb.append(" ").append(broker.getBrokerName());
        String command = this.concatWithMqAdmin(broker, sb.toString());
        SSHExec exec = this.exec(broker, command);
        return this.handleResult(exec);
    }

    @Override
    public String deleteBroker(Broker broker) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("delete --broker").append(" --passport ").append(broker.getPassport());
        if (broker.getBrokerDir() != null && !broker.getBrokerDir().isEmpty()) {
            sb.append(" --broker-dir ").append(broker.getBrokerDir());
        }
        sb.append(" ").append(broker.getBrokerName());
        String command = this.concatWithMqAdmin(broker, sb.toString());
        SSHExec exec = this.exec(broker, command);
        return this.handleResult(exec);
    }

    protected String handleResult(SSHExec exec) throws Exception {
        if (exec.getResultProperty() != null && Integer.parseInt(exec.getResultProperty()) != 0) {
            StringBuilder buff = new StringBuilder();
            buff.append("retCode: " + exec.getResultProperty() + "\n");
            buff.append("output: " + exec.getOutputProperty() + "\n");
            buff.append("error: " + exec.getErrorProperty() + "\n");
            LOG.warning("Exec error: " + buff.toString());
            throw new Exception(buff.toString());
        }
        String result = exec.getOutputProperty();
        if (result == null) {
            throw new Exception("SSHExec failed");
        }
        LOG.warning("Exec result: " + result);
        return result;
    }

    protected SSHExec exec(Broker broker, String command) {
        SSHExec ssh = new SSHExec();
        ssh.setHost(broker.getNodeHost());
        ssh.setUsername(broker.getNodeUsername());
        ssh.setPassword(broker.getNodePassword());
        ssh.setTrust(true);
        ssh.setVerbose(true);
        ssh.setCommand(command);
        ssh.setFailonerror(false);
        ssh.execute();
        return ssh;
    }

    protected String concatWithMqAdmin(Broker broker, String cmd) {
        if (broker.getInstallDir() != null) {
            return "cd " + broker.getInstallDir() + "/bin" + " && ./mqadmin " + cmd;
        }
        return "mqadmin " + cmd;
    }
}

