/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant;

import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.FileScanner;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.condition.Os;
import com.bes.mq.shade.org.apache.tools.ant.types.Resource;
import com.bes.mq.shade.org.apache.tools.ant.types.ResourceFactory;
import com.bes.mq.shade.org.apache.tools.ant.types.resources.FileResource;
import com.bes.mq.shade.org.apache.tools.ant.types.selectors.FileSelector;
import com.bes.mq.shade.org.apache.tools.ant.types.selectors.SelectorScanner;
import com.bes.mq.shade.org.apache.tools.ant.types.selectors.SelectorUtils;
import com.bes.mq.shade.org.apache.tools.ant.types.selectors.TokenizedPath;
import com.bes.mq.shade.org.apache.tools.ant.types.selectors.TokenizedPattern;
import com.bes.mq.shade.org.apache.tools.ant.util.CollectionUtils;
import com.bes.mq.shade.org.apache.tools.ant.util.FileUtils;
import com.bes.mq.shade.org.apache.tools.ant.util.SymbolicLinkUtils;
import com.bes.mq.shade.org.apache.tools.ant.util.VectorSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DirectoryScanner
implements FileScanner,
SelectorScanner,
ResourceFactory {
    private static final boolean ON_VMS = Os.isFamily("openvms");
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.git", "**/.git/**", "**/.gitattributes", "**/.gitignore", "**/.gitmodules", "**/.hg", "**/.hg/**", "**/.hgignore", "**/.hgsub", "**/.hgsubstate", "**/.hgtags", "**/.bzr", "**/.bzr/**", "**/.bzrignore", "**/.DS_Store"};
    public static final int MAX_LEVELS_OF_SYMLINKS = 5;
    public static final String DOES_NOT_EXIST_POSTFIX = " does not exist.";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final SymbolicLinkUtils SYMLINK_UTILS = SymbolicLinkUtils.getSymbolicLinkUtils();
    private static final Set defaultExcludes = new HashSet();
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected FileSelector[] selectors = null;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected Vector filesDeselected;
    protected Vector dirsDeselected;
    protected boolean haveSlowResults = false;
    protected boolean isCaseSensitive = true;
    protected boolean errorOnMissingDir = true;
    private boolean followSymlinks = true;
    protected boolean everythingIncluded = true;
    private Set scannedDirs = new HashSet();
    private Map includeNonPatterns = new HashMap();
    private Map excludeNonPatterns = new HashMap();
    private TokenizedPattern[] includePatterns;
    private TokenizedPattern[] excludePatterns;
    private boolean areNonPatternSetsReady = false;
    private boolean scanning = false;
    private Object scanLock = new Object();
    private boolean slowScanning = false;
    private Object slowScanLock = new Object();
    private IllegalStateException illegal = null;
    private int maxLevelsOfSymlinks = 5;
    private Set notFollowedSymlinks = new HashSet();

    protected static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern, str, isCaseSensitive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDefaultExcludes() {
        Set set = defaultExcludes;
        synchronized (set) {
            return defaultExcludes.toArray(new String[defaultExcludes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addDefaultExclude(String s) {
        Set set = defaultExcludes;
        synchronized (set) {
            return defaultExcludes.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeDefaultExclude(String s) {
        Set set = defaultExcludes;
        synchronized (set) {
            return defaultExcludes.remove(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDefaultExcludes() {
        Set set = defaultExcludes;
        synchronized (set) {
            defaultExcludes.clear();
            for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
                defaultExcludes.add(DEFAULTEXCLUDES[i]);
            }
        }
    }

    public void setBasedir(String basedir) {
        this.setBasedir(basedir == null ? (File)null : new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public synchronized void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public synchronized File getBasedir() {
        return this.basedir;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public synchronized void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void setErrorOnMissingDir(boolean errorOnMissingDir) {
        this.errorOnMissingDir = errorOnMissingDir;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public synchronized void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public void setMaxLevelsOfSymlinks(int max) {
        this.maxLevelsOfSymlinks = max;
    }

    public synchronized void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                this.includes[i] = DirectoryScanner.normalizePattern(includes[i]);
            }
        }
    }

    public synchronized void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                this.excludes[i] = DirectoryScanner.normalizePattern(excludes[i]);
            }
        }
    }

    public synchronized void addExcludes(String[] excludes) {
        if (excludes != null && excludes.length > 0) {
            if (this.excludes != null && this.excludes.length > 0) {
                String[] tmp = new String[excludes.length + this.excludes.length];
                System.arraycopy(this.excludes, 0, tmp, 0, this.excludes.length);
                for (int i = 0; i < excludes.length; ++i) {
                    tmp[this.excludes.length + i] = DirectoryScanner.normalizePattern(excludes[i]);
                }
                this.excludes = tmp;
            } else {
                this.setExcludes(excludes);
            }
        }
    }

    private static String normalizePattern(String p) {
        String pattern = p.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (pattern.endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    public synchronized void setSelectors(FileSelector[] selectors) {
        this.selectors = selectors;
    }

    public synchronized boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scan() throws IllegalStateException {
        File savedBase;
        block36: {
            block34: {
                Object object;
                block33: {
                    Object object2 = this.scanLock;
                    synchronized (object2) {
                        if (this.scanning) {
                            while (true) {
                                if (!this.scanning) {
                                    if (this.illegal == null) return;
                                    throw this.illegal;
                                }
                                try {
                                    this.scanLock.wait();
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                        this.scanning = true;
                    }
                    savedBase = this.basedir;
                    try {
                        try {
                            DirectoryScanner e = this;
                            synchronized (e) {
                                boolean nullExcludes;
                                boolean nullIncludes;
                                block35: {
                                    block41: {
                                        block38: {
                                            block40: {
                                                block39: {
                                                    block37: {
                                                        String[] stringArray;
                                                        this.illegal = null;
                                                        this.clearResults();
                                                        boolean bl = nullIncludes = this.includes == null;
                                                        if (nullIncludes) {
                                                            String[] stringArray2 = new String[1];
                                                            stringArray = stringArray2;
                                                            stringArray2[0] = "**";
                                                        } else {
                                                            stringArray = this.includes;
                                                        }
                                                        this.includes = stringArray;
                                                        nullExcludes = this.excludes == null;
                                                        String[] stringArray3 = this.excludes = nullExcludes ? new String[]{} : this.excludes;
                                                        if (this.basedir != null && !this.followSymlinks && SYMLINK_UTILS.isSymbolicLink(this.basedir)) {
                                                            this.notFollowedSymlinks.add(this.basedir.getAbsolutePath());
                                                            this.basedir = null;
                                                        }
                                                        if (this.basedir != null) break block37;
                                                        if (nullIncludes) {
                                                            // MONITOREXIT @DISABLED, blocks:[32, 2, 3, 9] lbl38 : MonitorExitStatement: MONITOREXIT : e
                                                            Object var7_7 = null;
                                                            this.basedir = savedBase;
                                                            object = this.scanLock;
                                                            break block33;
                                                        }
                                                        break block38;
                                                    }
                                                    if (this.basedir.exists()) break block39;
                                                    if (this.errorOnMissingDir) {
                                                        this.illegal = new IllegalStateException("basedir " + this.basedir + DOES_NOT_EXIST_POSTFIX);
                                                        break block40;
                                                    } else {
                                                        // MONITOREXIT @DISABLED, blocks:[2, 3, 9, 30] lbl48 : MonitorExitStatement: MONITOREXIT : e
                                                        break block34;
                                                    }
                                                }
                                                if (!this.basedir.isDirectory()) {
                                                    this.illegal = new IllegalStateException("basedir " + this.basedir + " is not a" + " directory.");
                                                }
                                            }
                                            if (this.illegal != null) {
                                                throw this.illegal;
                                            }
                                        }
                                        if (!this.isIncluded(TokenizedPath.EMPTY_PATH)) break block41;
                                        if (!this.isExcluded(TokenizedPath.EMPTY_PATH)) {
                                            if (this.isSelected("", this.basedir)) {
                                                this.dirsIncluded.addElement("");
                                                break block35;
                                            } else {
                                                this.dirsDeselected.addElement("");
                                            }
                                            break block35;
                                        } else {
                                            this.dirsExcluded.addElement("");
                                        }
                                        break block35;
                                    }
                                    this.dirsNotIncluded.addElement("");
                                }
                                this.checkIncludePatterns();
                                this.clearCaches();
                                this.includes = nullIncludes ? null : this.includes;
                                this.excludes = nullExcludes ? null : this.excludes;
                                break block36;
                            }
                        }
                        catch (IOException ex) {
                            throw new BuildException(ex);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        this.basedir = savedBase;
                        Object object3 = this.scanLock;
                        synchronized (object3) {
                            this.scanning = false;
                            this.scanLock.notifyAll();
                            throw throwable;
                        }
                    }
                }
                synchronized (object) {
                    this.scanning = false;
                    this.scanLock.notifyAll();
                    return;
                }
            }
            Object var7_8 = null;
            this.basedir = savedBase;
            Object object = this.scanLock;
            synchronized (object) {
                this.scanning = false;
                this.scanLock.notifyAll();
                return;
            }
        }
        Object var7_9 = null;
        this.basedir = savedBase;
        Object object = this.scanLock;
        synchronized (object) {
            this.scanning = false;
            this.scanLock.notifyAll();
            return;
        }
    }

    private void checkIncludePatterns() {
        this.ensureNonPatternSetsReady();
        HashMap<TokenizedPath, String> newroots = new HashMap<TokenizedPath, String>();
        for (int i = 0; i < this.includePatterns.length; ++i) {
            String pattern = this.includePatterns[i].toString();
            if (this.shouldSkipPattern(pattern)) continue;
            newroots.put(this.includePatterns[i].rtrimWildcardTokens(), pattern);
        }
        Iterator iter = this.includeNonPatterns.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String pattern = (String)entry.getKey();
            if (this.shouldSkipPattern(pattern)) continue;
            newroots.put((TokenizedPath)entry.getValue(), pattern);
        }
        if (newroots.containsKey(TokenizedPath.EMPTY_PATH) && this.basedir != null) {
            this.scandir(this.basedir, "", true);
        } else {
            Iterator it = newroots.entrySet().iterator();
            File canonBase = null;
            if (this.basedir != null) {
                try {
                    canonBase = this.basedir.getCanonicalFile();
                }
                catch (IOException ex) {
                    throw new BuildException(ex);
                }
            }
            while (it.hasNext()) {
                File f;
                Map.Entry entry = it.next();
                TokenizedPath currentPath = (TokenizedPath)entry.getKey();
                String currentelement = currentPath.toString();
                if (this.basedir == null && !FileUtils.isAbsolutePath(currentelement)) continue;
                File myfile = new File(this.basedir, currentelement);
                if (myfile.exists()) {
                    try {
                        String path;
                        String string = path = this.basedir == null ? myfile.getCanonicalPath() : FILE_UTILS.removeLeadingPath(canonBase, myfile.getCanonicalFile());
                        if ((!path.equals(currentelement) || ON_VMS) && (myfile = currentPath.findFile(this.basedir, true)) != null && this.basedir != null) {
                            currentelement = FILE_UTILS.removeLeadingPath(this.basedir, myfile);
                            if (!currentPath.toString().equals(currentelement)) {
                                currentPath = new TokenizedPath(currentelement);
                            }
                        }
                    }
                    catch (IOException ex) {
                        throw new BuildException(ex);
                    }
                }
                if (!(myfile != null && myfile.exists() || this.isCaseSensitive() || (f = currentPath.findFile(this.basedir, false)) == null || !f.exists())) {
                    currentelement = this.basedir == null ? f.getAbsolutePath() : FILE_UTILS.removeLeadingPath(this.basedir, f);
                    myfile = f;
                    currentPath = new TokenizedPath(currentelement);
                }
                if (myfile == null || !myfile.exists()) continue;
                if (!this.followSymlinks && currentPath.isSymlink(this.basedir)) {
                    if (this.isExcluded(currentPath)) continue;
                    this.notFollowedSymlinks.add(myfile.getAbsolutePath());
                    continue;
                }
                if (myfile.isDirectory()) {
                    if (this.isIncluded(currentPath) && currentelement.length() > 0) {
                        this.accountForIncludedDir(currentPath, myfile, true);
                        continue;
                    }
                    this.scandir(myfile, currentPath, true);
                    continue;
                }
                String originalpattern = (String)entry.getValue();
                boolean included = this.isCaseSensitive() ? originalpattern.equals(currentelement) : originalpattern.equalsIgnoreCase(currentelement);
                if (!included) continue;
                this.accountForIncludedFile(currentPath, myfile);
            }
        }
    }

    private boolean shouldSkipPattern(String pattern) {
        return FileUtils.isAbsolutePath(pattern) ? this.basedir != null && !SelectorUtils.matchPatternStart(pattern, this.basedir.getAbsolutePath(), this.isCaseSensitive()) : this.basedir == null;
    }

    protected synchronized void clearResults() {
        this.filesIncluded = new VectorSet();
        this.filesNotIncluded = new VectorSet();
        this.filesExcluded = new VectorSet();
        this.filesDeselected = new VectorSet();
        this.dirsIncluded = new VectorSet();
        this.dirsNotIncluded = new VectorSet();
        this.dirsExcluded = new VectorSet();
        this.dirsDeselected = new VectorSet();
        this.everythingIncluded = this.basedir != null;
        this.scannedDirs.clear();
        this.notFollowedSymlinks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void slowScan() {
        Object object;
        Object object2 = this.slowScanLock;
        synchronized (object2) {
            if (this.haveSlowResults) {
                return;
            }
            if (this.slowScanning) {
                while (this.slowScanning) {
                    try {
                        this.slowScanLock.wait();
                    }
                    catch (InterruptedException e) {}
                }
                return;
            }
            this.slowScanning = true;
        }
        try {
            object2 = this;
            synchronized (object2) {
                String[] stringArray;
                boolean nullIncludes;
                boolean bl = nullIncludes = this.includes == null;
                if (nullIncludes) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "**";
                } else {
                    stringArray = this.includes;
                }
                this.includes = stringArray;
                boolean nullExcludes = this.excludes == null;
                this.excludes = nullExcludes ? new String[]{} : this.excludes;
                Object[] excl = new String[this.dirsExcluded.size()];
                this.dirsExcluded.copyInto(excl);
                Object[] notIncl = new String[this.dirsNotIncluded.size()];
                this.dirsNotIncluded.copyInto(notIncl);
                this.ensureNonPatternSetsReady();
                this.processSlowScan((String[])excl);
                this.processSlowScan((String[])notIncl);
                this.clearCaches();
                this.includes = nullIncludes ? null : this.includes;
                this.excludes = nullExcludes ? null : this.excludes;
            }
            Object var8_9 = null;
            object = this.slowScanLock;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Object object3 = this.slowScanLock;
            synchronized (object3) {
                this.haveSlowResults = true;
                this.slowScanning = false;
                this.slowScanLock.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            this.haveSlowResults = true;
            this.slowScanning = false;
            this.slowScanLock.notifyAll();
        }
    }

    private void processSlowScan(String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            TokenizedPath path = new TokenizedPath(arr[i]);
            if (this.couldHoldIncluded(path) && !this.contentsExcluded(path)) continue;
            this.scandir(new File(this.basedir, arr[i]), path, false);
        }
    }

    protected void scandir(File dir, String vpath, boolean fast) {
        this.scandir(dir, new TokenizedPath(vpath), fast);
    }

    private void scandir(File dir, TokenizedPath path, boolean fast) {
        if (dir == null) {
            throw new BuildException("dir must not be null.");
        }
        String[] newfiles = dir.list();
        if (newfiles == null) {
            if (!dir.exists()) {
                throw new BuildException(dir + DOES_NOT_EXIST_POSTFIX);
            }
            if (!dir.isDirectory()) {
                throw new BuildException(dir + " is not a directory.");
            }
            throw new BuildException("IO error scanning directory '" + dir.getAbsolutePath() + "'");
        }
        this.scandir(dir, path, fast, newfiles, new LinkedList());
    }

    private void scandir(File dir, TokenizedPath path, boolean fast, String[] newfiles, LinkedList directoryNamesFollowed) {
        File file;
        String vpath = path.toString();
        if (vpath.length() > 0 && !vpath.endsWith(File.separator)) {
            vpath = vpath + File.separator;
        }
        if (fast && this.hasBeenScanned(vpath)) {
            return;
        }
        if (!this.followSymlinks) {
            ArrayList<String> noLinks = new ArrayList<String>();
            for (int i = 0; i < newfiles.length; ++i) {
                try {
                    if (SYMLINK_UTILS.isSymbolicLink(dir, newfiles[i])) {
                        String name = vpath + newfiles[i];
                        file = new File(dir, newfiles[i]);
                        (file.isDirectory() ? this.dirsExcluded : this.filesExcluded).addElement(name);
                        if (this.isExcluded(name)) continue;
                        this.notFollowedSymlinks.add(file.getAbsolutePath());
                        continue;
                    }
                    noLinks.add(newfiles[i]);
                    continue;
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println(msg);
                    noLinks.add(newfiles[i]);
                }
            }
            newfiles = noLinks.toArray(new String[noLinks.size()]);
        } else {
            directoryNamesFollowed.addFirst(dir.getName());
        }
        for (int i = 0; i < newfiles.length; ++i) {
            String name = vpath + newfiles[i];
            TokenizedPath newPath = new TokenizedPath(path, newfiles[i]);
            file = new File(dir, newfiles[i]);
            String[] children = file.list();
            if (children == null || children.length == 0 && file.isFile()) {
                if (this.isIncluded(newPath)) {
                    this.accountForIncludedFile(newPath, file);
                    continue;
                }
                this.everythingIncluded = false;
                this.filesNotIncluded.addElement(name);
                continue;
            }
            if (this.followSymlinks && this.causesIllegalSymlinkLoop(newfiles[i], dir, directoryNamesFollowed)) {
                System.err.println("skipping symbolic link " + file.getAbsolutePath() + " -- too many levels of symbolic" + " links.");
                this.notFollowedSymlinks.add(file.getAbsolutePath());
                continue;
            }
            if (this.isIncluded(newPath)) {
                this.accountForIncludedDir(newPath, file, fast, children, directoryNamesFollowed);
            } else {
                this.everythingIncluded = false;
                this.dirsNotIncluded.addElement(name);
                if (fast && this.couldHoldIncluded(newPath) && !this.contentsExcluded(newPath)) {
                    this.scandir(file, newPath, fast, children, directoryNamesFollowed);
                }
            }
            if (fast) continue;
            this.scandir(file, newPath, fast, children, directoryNamesFollowed);
        }
        if (this.followSymlinks) {
            directoryNamesFollowed.removeFirst();
        }
    }

    private void accountForIncludedFile(TokenizedPath name, File file) {
        this.processIncluded(name, file, this.filesIncluded, this.filesExcluded, this.filesDeselected);
    }

    private void accountForIncludedDir(TokenizedPath name, File file, boolean fast) {
        this.processIncluded(name, file, this.dirsIncluded, this.dirsExcluded, this.dirsDeselected);
        if (fast && this.couldHoldIncluded(name) && !this.contentsExcluded(name)) {
            this.scandir(file, name, fast);
        }
    }

    private void accountForIncludedDir(TokenizedPath name, File file, boolean fast, String[] children, LinkedList directoryNamesFollowed) {
        this.processIncluded(name, file, this.dirsIncluded, this.dirsExcluded, this.dirsDeselected);
        if (fast && this.couldHoldIncluded(name) && !this.contentsExcluded(name)) {
            this.scandir(file, name, fast, children, directoryNamesFollowed);
        }
    }

    private void processIncluded(TokenizedPath path, File file, Vector inc, Vector exc, Vector des) {
        String name = path.toString();
        if (inc.contains(name) || exc.contains(name) || des.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(path)) {
            exc.add(name);
        } else if (this.isSelected(name, file)) {
            included = true;
            inc.add(name);
        } else {
            des.add(name);
        }
        this.everythingIncluded &= included;
    }

    protected boolean isIncluded(String name) {
        return this.isIncluded(new TokenizedPath(name));
    }

    private boolean isIncluded(TokenizedPath path) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.includeNonPatterns.containsKey(path.toString()) : this.includeNonPatterns.containsKey(path.toString().toUpperCase())) {
            return true;
        }
        for (int i = 0; i < this.includePatterns.length; ++i) {
            if (!this.includePatterns[i].matchPath(path, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        return this.couldHoldIncluded(new TokenizedPath(name));
    }

    private boolean couldHoldIncluded(TokenizedPath tokenizedName) {
        for (int i = 0; i < this.includePatterns.length; ++i) {
            if (!this.couldHoldIncluded(tokenizedName, this.includePatterns[i])) continue;
            return true;
        }
        Iterator iter = this.includeNonPatterns.values().iterator();
        while (iter.hasNext()) {
            if (!this.couldHoldIncluded(tokenizedName, ((TokenizedPath)iter.next()).toPattern())) continue;
            return true;
        }
        return false;
    }

    private boolean couldHoldIncluded(TokenizedPath tokenizedName, TokenizedPattern tokenizedInclude) {
        return tokenizedInclude.matchStartOf(tokenizedName, this.isCaseSensitive()) && this.isMorePowerfulThanExcludes(tokenizedName.toString()) && this.isDeeper(tokenizedInclude, tokenizedName);
    }

    private boolean isDeeper(TokenizedPattern pattern, TokenizedPath name) {
        return pattern.containsPattern("**") || pattern.depth() > name.depth();
    }

    private boolean isMorePowerfulThanExcludes(String name) {
        String soughtexclude = name + File.separatorChar + "**";
        for (int counter = 0; counter < this.excludePatterns.length; ++counter) {
            if (!this.excludePatterns[counter].toString().equals(soughtexclude)) continue;
            return false;
        }
        return true;
    }

    boolean contentsExcluded(TokenizedPath path) {
        for (int i = 0; i < this.excludePatterns.length; ++i) {
            if (!this.excludePatterns[i].endsWith("**") || !this.excludePatterns[i].withoutLastToken().matchPath(path, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        return this.isExcluded(new TokenizedPath(name));
    }

    private boolean isExcluded(TokenizedPath name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.excludeNonPatterns.containsKey(name.toString()) : this.excludeNonPatterns.containsKey(name.toString().toUpperCase())) {
            return true;
        }
        for (int i = 0; i < this.excludePatterns.length; ++i) {
            if (!this.excludePatterns[i].matchPath(name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelected(String name, File file) {
        if (this.selectors != null) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].isSelected(this.basedir, name, file)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIncludedFiles() {
        Object[] files;
        DirectoryScanner directoryScanner = this;
        synchronized (directoryScanner) {
            if (this.filesIncluded == null) {
                throw new IllegalStateException("Must call scan() first");
            }
            files = new String[this.filesIncluded.size()];
            this.filesIncluded.copyInto(files);
        }
        Arrays.sort(files);
        return files;
    }

    public synchronized int getIncludedFilesCount() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.filesIncluded.size();
    }

    public synchronized String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(files);
        return files;
    }

    public synchronized String[] getExcludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(files);
        return files;
    }

    public synchronized String[] getDeselectedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIncludedDirectories() {
        Object[] directories;
        DirectoryScanner directoryScanner = this;
        synchronized (directoryScanner) {
            if (this.dirsIncluded == null) {
                throw new IllegalStateException("Must call scan() first");
            }
            directories = new String[this.dirsIncluded.size()];
            this.dirsIncluded.copyInto(directories);
        }
        Arrays.sort(directories);
        return directories;
    }

    public synchronized int getIncludedDirsCount() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.dirsIncluded.size();
    }

    public synchronized String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(directories);
        return directories;
    }

    public synchronized String[] getExcludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(directories);
        return directories;
    }

    public synchronized String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(directories);
        return directories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getNotFollowedSymlinks() {
        Object[] links;
        DirectoryScanner directoryScanner = this;
        synchronized (directoryScanner) {
            links = this.notFollowedSymlinks.toArray(new String[this.notFollowedSymlinks.size()]);
        }
        Arrays.sort(links);
        return links;
    }

    public synchronized void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] defaultExcludesTemp = DirectoryScanner.getDefaultExcludes();
        String[] newExcludes = new String[excludesLength + defaultExcludesTemp.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        for (int i = 0; i < defaultExcludesTemp.length; ++i) {
            newExcludes[i + excludesLength] = defaultExcludesTemp[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    public synchronized Resource getResource(String name) {
        return new FileResource(this.basedir, name);
    }

    private boolean hasBeenScanned(String vpath) {
        return !this.scannedDirs.add(vpath);
    }

    Set getScannedDirs() {
        return this.scannedDirs;
    }

    private synchronized void clearCaches() {
        this.includeNonPatterns.clear();
        this.excludeNonPatterns.clear();
        this.includePatterns = null;
        this.excludePatterns = null;
        this.areNonPatternSetsReady = false;
    }

    synchronized void ensureNonPatternSetsReady() {
        if (!this.areNonPatternSetsReady) {
            this.includePatterns = this.fillNonPatternSet(this.includeNonPatterns, this.includes);
            this.excludePatterns = this.fillNonPatternSet(this.excludeNonPatterns, this.excludes);
            this.areNonPatternSetsReady = true;
        }
    }

    private TokenizedPattern[] fillNonPatternSet(Map map, String[] patterns) {
        ArrayList<TokenizedPattern> al = new ArrayList<TokenizedPattern>(patterns.length);
        for (int i = 0; i < patterns.length; ++i) {
            if (!SelectorUtils.hasWildcards(patterns[i])) {
                String s = this.isCaseSensitive() ? patterns[i] : patterns[i].toUpperCase();
                map.put(s, new TokenizedPath(s));
                continue;
            }
            al.add(new TokenizedPattern(patterns[i]));
        }
        return al.toArray(new TokenizedPattern[al.size()]);
    }

    private boolean causesIllegalSymlinkLoop(String dirName, File parent, LinkedList directoryNamesFollowed) {
        try {
            if (directoryNamesFollowed.size() >= this.maxLevelsOfSymlinks && CollectionUtils.frequency(directoryNamesFollowed, dirName) >= this.maxLevelsOfSymlinks && SYMLINK_UTILS.isSymbolicLink(parent, dirName)) {
                ArrayList<String> files = new ArrayList<String>();
                File f = FILE_UTILS.resolveFile(parent, dirName);
                String target = f.getCanonicalPath();
                files.add(target);
                String relPath = "";
                Iterator i = directoryNamesFollowed.iterator();
                while (i.hasNext()) {
                    relPath = relPath + "../";
                    String dir = (String)i.next();
                    if (!dirName.equals(dir)) continue;
                    f = FILE_UTILS.resolveFile(parent, relPath + dir);
                    files.add(f.getCanonicalPath());
                    if (files.size() <= this.maxLevelsOfSymlinks || CollectionUtils.frequency(files, target) <= this.maxLevelsOfSymlinks) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IOException ex) {
            throw new BuildException("Caught error while checking for symbolic links", ex);
        }
    }

    static {
        DirectoryScanner.resetDefaultExcludes();
    }
}

