/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.filters;

import com.bes.mq.shade.org.apache.tools.ant.filters.BaseParamFilterReader;
import com.bes.mq.shade.org.apache.tools.ant.filters.ChainableReader;
import com.bes.mq.shade.org.apache.tools.ant.types.Parameter;
import java.io.IOException;
import java.io.Reader;

public final class StripLineBreaks
extends BaseParamFilterReader
implements ChainableReader {
    private static final String DEFAULT_LINE_BREAKS = "\r\n";
    private static final String LINE_BREAKS_KEY = "linebreaks";
    private String lineBreaks = "\r\n";

    public StripLineBreaks() {
    }

    public StripLineBreaks(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch = this.in.read();
        while (ch != -1 && this.lineBreaks.indexOf(ch) != -1) {
            ch = this.in.read();
        }
        return ch;
    }

    public void setLineBreaks(String lineBreaks) {
        this.lineBreaks = lineBreaks;
    }

    private String getLineBreaks() {
        return this.lineBreaks;
    }

    public Reader chain(Reader rdr) {
        StripLineBreaks newFilter = new StripLineBreaks(rdr);
        newFilter.setLineBreaks(this.getLineBreaks());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private void initialize() {
        String userDefinedLineBreaks = null;
        Parameter[] params = this.getParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!LINE_BREAKS_KEY.equals(params[i].getName())) continue;
                userDefinedLineBreaks = params[i].getValue();
                break;
            }
        }
        if (userDefinedLineBreaks != null) {
            this.lineBreaks = userDefinedLineBreaks;
        }
    }
}

