/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.taskdefs;

import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.Unpack;
import com.bes.mq.shade.org.apache.tools.ant.util.FileUtils;
import com.bes.mq.shade.org.apache.tools.bzip2.CBZip2InputStream;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BUnzip2
extends Unpack {
    private static final int BUFFER_SIZE = 8192;
    private static final String DEFAULT_EXTENSION = ".bz2";

    protected String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extract() {
        if (this.source.lastModified() <= this.dest.lastModified()) return;
        this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
        FileOutputStream out = null;
        CBZip2InputStream zIn = null;
        InputStream fis = null;
        BufferedInputStream bis = null;
        try {
            try {
                out = new FileOutputStream(this.dest);
                fis = this.srcResource.getInputStream();
                bis = new BufferedInputStream(fis);
                int b = bis.read();
                if (b != 66) {
                    throw new BuildException("Invalid bz2 file.", this.getLocation());
                }
                b = bis.read();
                if (b != 90) {
                    throw new BuildException("Invalid bz2 file.", this.getLocation());
                }
                zIn = new CBZip2InputStream(bis);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
            }
            catch (IOException ioe) {
                String msg = "Problem expanding bzip2 " + ioe.getMessage();
                throw new BuildException(msg, ioe, this.getLocation());
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            FileUtils.close(bis);
            FileUtils.close(fis);
            FileUtils.close(out);
            FileUtils.close(zIn);
            throw throwable;
        }
        FileUtils.close(bis);
        FileUtils.close(fis);
        FileUtils.close(out);
        FileUtils.close(zIn);
    }

    protected boolean supportsNonFileResources() {
        return this.getClass().equals(BUnzip2.class);
    }
}

