/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.taskdefs;

import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.DirectoryScanner;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.Copy;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.condition.Os;
import com.bes.mq.shade.org.apache.tools.ant.types.FileSet;
import com.bes.mq.shade.org.apache.tools.ant.types.FilterSet;
import com.bes.mq.shade.org.apache.tools.ant.types.FilterSetCollection;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class Move
extends Copy {
    private boolean performGc = Os.isFamily("windows");

    public Move() {
        this.setOverwrite(true);
    }

    public void setPerformGcOnFailedDelete(boolean b) {
        this.performGc = b;
    }

    protected void validateAttributes() throws BuildException {
        if (this.file != null && this.file.isDirectory()) {
            if (this.destFile != null && this.destDir != null || this.destFile == null && this.destDir == null) {
                throw new BuildException("One and only one of tofile and todir must be set.");
            }
            this.destFile = this.destFile == null ? new File(this.destDir, this.file.getName()) : this.destFile;
            this.destDir = this.destDir == null ? this.destFile.getParentFile() : this.destDir;
            this.completeDirMap.put(this.file, this.destFile);
            this.file = null;
        } else {
            super.validateAttributes();
        }
    }

    protected void doFileOperations() {
        int moveCount;
        if (this.completeDirMap.size() > 0) {
            Iterator fromDirs = this.completeDirMap.keySet().iterator();
            while (fromDirs.hasNext()) {
                File fromDir = (File)fromDirs.next();
                File toDir = (File)this.completeDirMap.get(fromDir);
                boolean renamed = false;
                try {
                    this.log("Attempting to rename dir: " + fromDir + " to " + toDir, this.verbosity);
                    renamed = this.renameFile(fromDir, toDir, this.filtering, this.forceOverwrite);
                }
                catch (IOException ioe) {
                    String msg = "Failed to rename dir " + fromDir + " to " + toDir + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
                if (renamed) continue;
                FileSet fs = new FileSet();
                fs.setProject(this.getProject());
                fs.setDir(fromDir);
                this.addFileset(fs);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] files = ds.getIncludedFiles();
                String[] dirs = ds.getIncludedDirectories();
                this.scan(fromDir, toDir, files, dirs);
            }
        }
        if ((moveCount = this.fileCopyMap.size()) > 0) {
            this.log("Moving " + moveCount + " file" + (moveCount == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Iterator fromFiles = this.fileCopyMap.keySet().iterator();
            while (fromFiles.hasNext()) {
                String fromFile = (String)fromFiles.next();
                File f = new File(fromFile);
                boolean selfMove = false;
                if (!f.exists()) continue;
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                for (int i = 0; i < toFiles.length; ++i) {
                    String toFile = toFiles[i];
                    if (fromFile.equals(toFile)) {
                        this.log("Skipping self-move of " + fromFile, this.verbosity);
                        selfMove = true;
                        continue;
                    }
                    File d = new File(toFile);
                    if (i + 1 == toFiles.length && !selfMove) {
                        this.moveFile(f, d, this.filtering, this.forceOverwrite);
                        continue;
                    }
                    this.copyFile(f, d, this.filtering, this.forceOverwrite);
                }
            }
        }
        if (this.includeEmpty) {
            int createCount = 0;
            Iterator fromDirNames = this.dirCopyMap.keySet().iterator();
            while (fromDirNames.hasNext()) {
                String fromDirName = (String)fromDirNames.next();
                String[] toDirNames = (String[])this.dirCopyMap.get(fromDirName);
                boolean selfMove = false;
                for (int i = 0; i < toDirNames.length; ++i) {
                    if (fromDirName.equals(toDirNames[i])) {
                        this.log("Skipping self-move of " + fromDirName, this.verbosity);
                        selfMove = true;
                        continue;
                    }
                    File d = new File(toDirNames[i]);
                    if (d.exists()) continue;
                    if (!d.mkdirs()) {
                        this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                        continue;
                    }
                    ++createCount;
                }
                File fromDir = new File(fromDirName);
                if (selfMove || !this.okToDelete(fromDir)) continue;
                this.deleteDir(fromDir);
            }
            if (createCount > 0) {
                this.log("Moved " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + createCount + " empty director" + (createCount == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }

    private void moveFile(File fromFile, File toFile, boolean filtering, boolean overwrite) {
        boolean moved = false;
        try {
            this.log("Attempting to rename: " + fromFile + " to " + toFile, this.verbosity);
            moved = this.renameFile(fromFile, toFile, filtering, this.forceOverwrite);
        }
        catch (IOException ioe) {
            String msg = "Failed to rename " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
            throw new BuildException(msg, ioe, this.getLocation());
        }
        if (!moved) {
            this.copyFile(fromFile, toFile, filtering, overwrite);
            if (!this.getFileUtils().tryHardToDelete(fromFile, this.performGc)) {
                throw new BuildException("Unable to delete file " + fromFile.getAbsolutePath());
            }
        }
    }

    private void copyFile(File fromFile, File toFile, boolean filtering, boolean overwrite) {
        try {
            this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
            FilterSetCollection executionFilters = new FilterSetCollection();
            if (filtering) {
                executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
            }
            Iterator filterIter = this.getFilterSets().iterator();
            while (filterIter.hasNext()) {
                executionFilters.addFilterSet((FilterSet)filterIter.next());
            }
            this.getFileUtils().copyFile(fromFile, toFile, executionFilters, this.getFilterChains(), this.forceOverwrite, this.getPreserveLastModified(), false, this.getEncoding(), this.getOutputEncoding(), this.getProject(), this.getForce());
        }
        catch (IOException ioe) {
            String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
            throw new BuildException(msg, ioe, this.getLocation());
        }
    }

    protected boolean okToDelete(File d) {
        String[] list = d.list();
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                if (this.okToDelete(f)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected void deleteDir(File d) {
        this.deleteDir(d, false);
    }

    protected void deleteDir(File d, boolean deleteFiles) {
        String[] list = d.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (!f.isDirectory()) {
                if (deleteFiles && !this.getFileUtils().tryHardToDelete(f, this.performGc)) {
                    throw new BuildException("Unable to delete file " + f.getAbsolutePath());
                }
                throw new BuildException("UNEXPECTED ERROR - The file " + f.getAbsolutePath() + " should not exist!");
            }
            this.deleteDir(f);
        }
        this.log("Deleting directory " + d.getAbsolutePath(), this.verbosity);
        if (!this.getFileUtils().tryHardToDelete(d, this.performGc)) {
            throw new BuildException("Unable to delete directory " + d.getAbsolutePath());
        }
    }

    protected boolean renameFile(File sourceFile, File destFile, boolean filtering, boolean overwrite) throws IOException, BuildException {
        File parent;
        if (destFile.isDirectory() || filtering || this.getFilterSets().size() > 0 || this.getFilterChains().size() > 0) {
            return false;
        }
        if (destFile.isFile() && !destFile.canWrite()) {
            if (!this.getForce()) {
                throw new IOException("can't replace read-only destination file " + destFile);
            }
            if (!this.getFileUtils().tryHardToDelete(destFile)) {
                throw new IOException("failed to delete read-only destination file " + destFile);
            }
        }
        if ((parent = destFile.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        } else if (destFile.isFile()) {
            sourceFile = this.getFileUtils().normalize(sourceFile.getAbsolutePath()).getCanonicalFile();
            destFile = this.getFileUtils().normalize(destFile.getAbsolutePath());
            if (destFile.getAbsolutePath().equals(sourceFile.getAbsolutePath())) {
                this.log("Rename of " + sourceFile + " to " + destFile + " is a no-op.", 3);
                return true;
            }
            if (!this.getFileUtils().areSame(sourceFile, destFile) && !this.getFileUtils().tryHardToDelete(destFile, this.performGc)) {
                throw new BuildException("Unable to remove existing file " + destFile);
            }
        }
        return sourceFile.renameTo(destFile);
    }
}

