/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.taskdefs;

import com.bes.mq.shade.org.apache.tools.ant.AntClassLoader;
import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.Project;
import com.bes.mq.shade.org.apache.tools.ant.PropertyHelper;
import com.bes.mq.shade.org.apache.tools.ant.Task;
import com.bes.mq.shade.org.apache.tools.ant.property.ResolvePropertyMap;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.Execute;
import com.bes.mq.shade.org.apache.tools.ant.types.Path;
import com.bes.mq.shade.org.apache.tools.ant.types.Reference;
import com.bes.mq.shade.org.apache.tools.ant.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class Property
extends Task {
    protected String name;
    protected String value;
    protected File file;
    protected URL url;
    protected String resource;
    protected Path classpath;
    protected String env;
    protected Reference ref;
    protected String prefix;
    private Project fallback;
    private Object untypedValue;
    private boolean valueAttributeUsed = false;
    private boolean relative = false;
    private File basedir;
    private boolean prefixValues = false;
    protected boolean userProperty;

    public Property() {
        this(false);
    }

    protected Property(boolean userProperty) {
        this(userProperty, null);
    }

    protected Property(boolean userProperty, Project fallback) {
        this.userProperty = userProperty;
        this.fallback = fallback;
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(File location) {
        if (this.relative) {
            this.internalSetValue(location);
        } else {
            this.setValue(location.getAbsolutePath());
        }
    }

    public void setValue(Object value) {
        this.valueAttributeUsed = true;
        this.internalSetValue(value);
    }

    private void internalSetValue(Object value) {
        this.untypedValue = value;
        this.value = value == null ? null : value.toString();
    }

    public void setValue(String value) {
        this.setValue((Object)value);
    }

    public void addText(String msg) {
        if (!this.valueAttributeUsed) {
            msg = this.getProject().replaceProperties(msg);
            String currentValue = this.getValue();
            if (currentValue != null) {
                msg = currentValue + msg;
            }
            this.internalSetValue(msg);
        } else if (msg.trim().length() > 0) {
            throw new BuildException("can't combine nested text with value attribute");
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (prefix != null && !prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefixValues(boolean b) {
        this.prefixValues = b;
    }

    public boolean getPrefixValues() {
        return this.prefixValues;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
    }

    public Reference getRefid() {
        return this.ref;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public void setEnvironment(String env) {
        this.env = env;
    }

    public String getEnvironment() {
        return this.env;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setUserProperty(boolean userProperty) {
        this.log("DEPRECATED: Ignoring request to set user property in Property task.", 1);
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    public void execute() throws BuildException {
        if (this.getProject() == null) {
            throw new IllegalStateException("project has not been set");
        }
        if (this.name != null) {
            if (this.untypedValue == null && this.ref == null) {
                throw new BuildException("You must specify value, location or refid with the name attribute", this.getLocation());
            }
        } else if (this.url == null && this.file == null && this.resource == null && this.env == null) {
            throw new BuildException("You must specify url, file, resource or environment when not using the name attribute", this.getLocation());
        }
        if (this.url == null && this.file == null && this.resource == null && this.prefix != null) {
            throw new BuildException("Prefix is only valid when loading from a url, file or resource", this.getLocation());
        }
        if (this.name != null && this.untypedValue != null) {
            if (this.relative) {
                try {
                    File from = this.untypedValue instanceof File ? (File)this.untypedValue : new File(this.untypedValue.toString());
                    File to = this.basedir != null ? this.basedir : this.getProject().getBaseDir();
                    String relPath = FileUtils.getRelativePath(to, from);
                    relPath = relPath.replace('/', File.separatorChar);
                    this.addProperty(this.name, relPath);
                }
                catch (Exception e) {
                    throw new BuildException(e, this.getLocation());
                }
            } else {
                this.addProperty(this.name, this.untypedValue);
            }
        }
        if (this.file != null) {
            this.loadFile(this.file);
        }
        if (this.url != null) {
            this.loadUrl(this.url);
        }
        if (this.resource != null) {
            this.loadResource(this.resource);
        }
        if (this.env != null) {
            this.loadEnvironment(this.env);
        }
        if (this.name != null && this.ref != null) {
            try {
                this.addProperty(this.name, this.ref.getReferencedObject(this.getProject()).toString());
            }
            catch (BuildException be) {
                if (this.fallback != null) {
                    this.addProperty(this.name, this.ref.getReferencedObject(this.fallback).toString());
                }
                throw be;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadUrl(URL url) throws BuildException {
        Properties props = new Properties();
        this.log("Loading " + url, 3);
        try {
            InputStream is = url.openStream();
            try {
                this.loadProperties(props, is, url.getFile().endsWith(".xml"));
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            this.addProperties(props);
        }
        catch (IOException ex) {
            throw new BuildException(ex, this.getLocation());
        }
    }

    private void loadProperties(Properties props, InputStream is, boolean isXml) throws IOException {
        if (isXml) {
            try {
                Method loadXmlMethod = props.getClass().getMethod("loadFromXML", InputStream.class);
                loadXmlMethod.invoke((Object)props, is);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                this.log("Can not load xml based property definition on Java < 5");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            props.load(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(File file) throws BuildException {
        block4: {
            Properties props = new Properties();
            this.log("Loading " + file.getAbsolutePath(), 3);
            try {
                block5: {
                    if (!file.exists()) break block5;
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(file);
                        this.loadProperties(props, fis, file.getName().endsWith(".xml"));
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(fis);
                        throw throwable;
                    }
                    FileUtils.close(fis);
                    this.addProperties(props);
                    break block4;
                }
                this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
            }
            catch (IOException ex) {
                throw new BuildException(ex, this.getLocation());
            }
        }
    }

    /*
     * Loose catch block
     */
    protected void loadResource(String name) {
        block15: {
            boolean cleanup;
            ClassLoader cL;
            InputStream is;
            block14: {
                block13: {
                    Properties props = new Properties();
                    this.log("Resource Loading " + name, 3);
                    is = null;
                    cL = null;
                    cleanup = false;
                    if (this.classpath != null) {
                        cleanup = true;
                        cL = this.getProject().createClassLoader(this.classpath);
                    } else {
                        cL = this.getClass().getClassLoader();
                    }
                    is = cL == null ? ClassLoader.getSystemResourceAsStream(name) : cL.getResourceAsStream(name);
                    if (is != null) {
                        this.loadProperties(props, is, name.endsWith(".xml"));
                        this.addProperties(props);
                        break block13;
                    }
                    this.log("Unable to find resource " + name, 1);
                }
                Object var8_6 = null;
                if (is == null) break block14;
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (cleanup && cL != null) {
                ((AntClassLoader)cL).cleanup();
            }
            break block15;
            {
                catch (IOException ex) {
                    throw new BuildException(ex, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (cleanup && cL != null) {
                    ((AntClassLoader)cL).cleanup();
                }
                throw throwable;
            }
        }
    }

    protected void loadEnvironment(String prefix) {
        Properties props = new Properties();
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.log("Loading Environment " + prefix, 3);
        Map osEnv = Execute.getEnvironmentVariables();
        Iterator e = osEnv.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            props.put(prefix + entry.getKey(), entry.getValue());
        }
        this.addProperties(props);
    }

    protected void addProperties(Properties props) {
        HashMap<Object, Object> m = new HashMap<Object, Object>(props);
        this.resolveAllProperties(m);
        Iterator<Object> it = m.keySet().iterator();
        while (it.hasNext()) {
            Object k = it.next();
            if (!(k instanceof String)) continue;
            String propertyName = (String)k;
            if (this.prefix != null) {
                propertyName = this.prefix + propertyName;
            }
            this.addProperty(propertyName, m.get(k));
        }
    }

    protected void addProperty(String n, String v) {
        this.addProperty(n, (Object)v);
    }

    protected void addProperty(String n, Object v) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(this.getProject());
        if (this.userProperty) {
            if (ph.getUserProperty(n) == null) {
                ph.setInheritedProperty(n, v);
            } else {
                this.log("Override ignored for " + n, 3);
            }
        } else {
            ph.setNewProperty(n, v);
        }
    }

    private void resolveAllProperties(Map props) throws BuildException {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this.getProject());
        new ResolvePropertyMap(this.getProject(), propertyHelper, propertyHelper.getExpanders()).resolveAllProperties(props, this.getPrefix(), this.getPrefixValues());
    }
}

