/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.taskdefs.condition;

import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.ProjectComponent;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.condition.Condition;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class IsReachable
extends ProjectComponent
implements Condition {
    private static final int SECOND = 1000;
    private String host;
    private String url;
    public static final int DEFAULT_TIMEOUT = 30;
    private int timeout = 30;
    public static final String ERROR_NO_HOSTNAME = "No hostname defined";
    public static final String ERROR_BAD_TIMEOUT = "Invalid timeout value";
    private static final String WARN_UNKNOWN_HOST = "Unknown host: ";
    public static final String ERROR_ON_NETWORK = "network error to ";
    public static final String ERROR_BOTH_TARGETS = "Both url and host have been specified";
    public static final String MSG_NO_REACHABLE_TEST = "cannot do a proper reachability test on this Java version";
    public static final String ERROR_BAD_URL = "Bad URL ";
    public static final String ERROR_NO_HOST_IN_URL = "No hostname in URL ";
    public static final String METHOD_NAME = "isReachable";
    private static Class[] parameterTypes = new Class[]{Integer.TYPE};

    public void setHost(String host) {
        this.host = host;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private boolean empty(String string) {
        return string == null || string.length() == 0;
    }

    public boolean eval() throws BuildException {
        boolean reachable;
        InetAddress address;
        if (this.empty(this.host) && this.empty(this.url)) {
            throw new BuildException(ERROR_NO_HOSTNAME);
        }
        if (this.timeout < 0) {
            throw new BuildException(ERROR_BAD_TIMEOUT);
        }
        String target = this.host;
        if (!this.empty(this.url)) {
            if (!this.empty(this.host)) {
                throw new BuildException(ERROR_BOTH_TARGETS);
            }
            try {
                URL realURL = new URL(this.url);
                target = realURL.getHost();
                if (this.empty(target)) {
                    throw new BuildException(ERROR_NO_HOST_IN_URL + this.url);
                }
            }
            catch (MalformedURLException e) {
                throw new BuildException(ERROR_BAD_URL + this.url, e);
            }
        }
        this.log("Probing host " + target, 3);
        try {
            address = InetAddress.getByName(target);
        }
        catch (UnknownHostException e1) {
            this.log(WARN_UNKNOWN_HOST + target);
            return false;
        }
        this.log("Host address = " + address.getHostAddress(), 3);
        Method reachableMethod = null;
        try {
            reachableMethod = InetAddress.class.getMethod(METHOD_NAME, parameterTypes);
            Object[] params = new Object[]{new Integer(this.timeout * 1000)};
            try {
                reachable = (Boolean)reachableMethod.invoke((Object)address, params);
            }
            catch (IllegalAccessException e) {
                throw new BuildException("When calling " + reachableMethod);
            }
            catch (InvocationTargetException e) {
                Throwable nested = e.getTargetException();
                this.log(ERROR_ON_NETWORK + target + ": " + nested.toString());
                reachable = false;
            }
        }
        catch (NoSuchMethodException e) {
            this.log("Not found: InetAddress.isReachable", 3);
            this.log(MSG_NO_REACHABLE_TEST);
            reachable = true;
        }
        this.log("host is" + (reachable ? "" : " not") + " reachable", 3);
        return reachable;
    }
}

