/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.taskdefs.optional;

import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.Task;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.optional.javah.JavahAdapter;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.optional.javah.JavahAdapterFactory;
import com.bes.mq.shade.org.apache.tools.ant.types.Commandline;
import com.bes.mq.shade.org.apache.tools.ant.types.FileSet;
import com.bes.mq.shade.org.apache.tools.ant.types.Path;
import com.bes.mq.shade.org.apache.tools.ant.types.Reference;
import com.bes.mq.shade.org.apache.tools.ant.util.StringUtils;
import com.bes.mq.shade.org.apache.tools.ant.util.facade.FacadeTaskHelper;
import com.bes.mq.shade.org.apache.tools.ant.util.facade.ImplementationSpecificArgument;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Javah
extends Task {
    private Vector classes = new Vector(2);
    private String cls;
    private File destDir;
    private Path classpath = null;
    private File outputFile = null;
    private boolean verbose = false;
    private boolean force = false;
    private boolean old = false;
    private boolean stubs = false;
    private Path bootclasspath;
    private FacadeTaskHelper facade = null;
    private Vector files = new Vector();
    private JavahAdapter nestedAdapter = null;

    public Javah() {
        this.facade = new FacadeTaskHelper(JavahAdapterFactory.getDefault());
    }

    public void setClass(String cls) {
        this.cls = cls;
    }

    public ClassArgument createClass() {
        ClassArgument ga = new ClassArgument();
        this.classes.addElement(ga);
        return ga;
    }

    public void addFileSet(FileSet fs) {
        this.files.add(fs);
    }

    public String[] getClasses() {
        Enumeration e;
        ArrayList<String> al = new ArrayList<String>();
        if (this.cls != null) {
            StringTokenizer tok = new StringTokenizer(this.cls, ",", false);
            while (tok.hasMoreTokens()) {
                al.add(tok.nextToken().trim());
            }
        }
        if (this.files.size() > 0) {
            e = this.files.elements();
            while (e.hasMoreElements()) {
                FileSet fs = (FileSet)e.nextElement();
                String[] includedClasses = fs.getDirectoryScanner(this.getProject()).getIncludedFiles();
                for (int i = 0; i < includedClasses.length; ++i) {
                    String className = includedClasses[i].replace('\\', '.').replace('/', '.').substring(0, includedClasses[i].length() - 6);
                    al.add(className);
                }
            }
        }
        e = this.classes.elements();
        while (e.hasMoreElements()) {
            ClassArgument arg = (ClassArgument)e.nextElement();
            al.add(arg.getName());
        }
        return al.toArray(new String[al.size()]);
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setClasspath(Path src) {
        if (this.classpath == null) {
            this.classpath = src;
        } else {
            this.classpath.append(src);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setBootclasspath(Path src) {
        if (this.bootclasspath == null) {
            this.bootclasspath = src;
        } else {
            this.bootclasspath.append(src);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference r) {
        this.createBootclasspath().setRefid(r);
    }

    public Path getBootclasspath() {
        return this.bootclasspath;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getOutputfile() {
        return this.outputFile;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setOld(boolean old) {
        this.old = old;
    }

    public boolean getOld() {
        return this.old;
    }

    public void setStubs(boolean stubs) {
        this.stubs = stubs;
    }

    public boolean getStubs() {
        return this.stubs;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setImplementation(String impl) {
        if ("default".equals(impl)) {
            this.facade.setImplementation(JavahAdapterFactory.getDefault());
        } else {
            this.facade.setImplementation(impl);
        }
    }

    public ImplementationSpecificArgument createArg() {
        ImplementationSpecificArgument arg = new ImplementationSpecificArgument();
        this.facade.addImplementationArgument(arg);
        return arg;
    }

    public String[] getCurrentArgs() {
        return this.facade.getArgs();
    }

    public Path createImplementationClasspath() {
        return this.facade.getImplementationClasspath(this.getProject());
    }

    public void add(JavahAdapter adapter) {
        if (this.nestedAdapter != null) {
            throw new BuildException("Can't have more than one javah adapter");
        }
        this.nestedAdapter = adapter;
    }

    public void execute() throws BuildException {
        JavahAdapter ad;
        if (this.cls == null && this.classes.size() == 0 && this.files.size() == 0) {
            throw new BuildException("class attribute must be set!", this.getLocation());
        }
        if (this.cls != null && this.classes.size() > 0 && this.files.size() > 0) {
            throw new BuildException("set class attribute OR class element OR fileset, not 2 or more of them.", this.getLocation());
        }
        if (this.destDir != null) {
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
            }
            if (this.outputFile != null) {
                throw new BuildException("destdir and outputFile are mutually exclusive", this.getLocation());
            }
        }
        this.classpath = this.classpath == null ? new Path(this.getProject()).concatSystemClasspath("last") : this.classpath.concatSystemClasspath("ignore");
        JavahAdapter javahAdapter = ad = this.nestedAdapter != null ? this.nestedAdapter : JavahAdapterFactory.getAdapter(this.facade.getImplementation(), this, this.createImplementationClasspath());
        if (!ad.compile(this)) {
            throw new BuildException("compilation failed");
        }
    }

    public void logAndAddFiles(Commandline cmd) {
        this.logAndAddFilesToCompile(cmd);
    }

    protected void logAndAddFilesToCompile(Commandline cmd) {
        this.log("Compilation " + cmd.describeArguments(), 3);
        StringBuffer niceClassList = new StringBuffer();
        String[] c = this.getClasses();
        for (int i = 0; i < c.length; ++i) {
            cmd.createArgument().setValue(c[i]);
            niceClassList.append("    ");
            niceClassList.append(c[i]);
            niceClassList.append(StringUtils.LINE_SEP);
        }
        StringBuffer prefix = new StringBuffer("Class");
        if (c.length > 1) {
            prefix.append("es");
        }
        prefix.append(" to be compiled:");
        prefix.append(StringUtils.LINE_SEP);
        this.log(prefix.toString() + niceClassList.toString(), 3);
    }

    public class ClassArgument {
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

