/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.taskdefs.optional.native2ascii;

import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.ProjectComponent;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.optional.native2ascii.KaffeNative2Ascii;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.optional.native2ascii.Native2AsciiAdapter;
import com.bes.mq.shade.org.apache.tools.ant.taskdefs.optional.native2ascii.SunNative2Ascii;
import com.bes.mq.shade.org.apache.tools.ant.types.Path;
import com.bes.mq.shade.org.apache.tools.ant.util.ClasspathUtils;
import com.bes.mq.shade.org.apache.tools.ant.util.JavaEnvUtils;

public class Native2AsciiAdapterFactory {
    public static String getDefault() {
        if (JavaEnvUtils.isKaffe()) {
            return "kaffe";
        }
        return "sun";
    }

    public static Native2AsciiAdapter getAdapter(String choice, ProjectComponent log) throws BuildException {
        return Native2AsciiAdapterFactory.getAdapter(choice, log, null);
    }

    public static Native2AsciiAdapter getAdapter(String choice, ProjectComponent log, Path classpath) throws BuildException {
        if (JavaEnvUtils.isKaffe() && choice == null || "kaffe".equals(choice)) {
            return new KaffeNative2Ascii();
        }
        if ("sun".equals(choice)) {
            return new SunNative2Ascii();
        }
        if (choice != null) {
            return Native2AsciiAdapterFactory.resolveClassName(choice, log.getProject().createClassLoader(classpath));
        }
        return new SunNative2Ascii();
    }

    private static Native2AsciiAdapter resolveClassName(String className, ClassLoader loader) throws BuildException {
        return (Native2AsciiAdapter)ClasspathUtils.newInstance(className, loader != null ? loader : Native2AsciiAdapterFactory.class.getClassLoader(), Native2AsciiAdapter.class);
    }
}

