/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.types;

import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.types.ArchiveScanner;
import com.bes.mq.shade.org.apache.tools.ant.types.Resource;
import com.bes.mq.shade.org.apache.tools.ant.types.resources.TarResource;
import com.bes.mq.shade.org.apache.tools.ant.util.FileUtils;
import com.bes.mq.shade.org.apache.tools.tar.TarEntry;
import com.bes.mq.shade.org.apache.tools.tar.TarInputStream;
import java.io.IOException;
import java.util.Map;

public class TarScanner
extends ArchiveScanner {
    protected void fillMapsFromArchive(Resource src, String encoding, Map fileEntries, Map matchFileEntries, Map dirEntries, Map matchDirEntries) {
        TarEntry entry = null;
        TarInputStream ti = null;
        try {
            try {
                ti = new TarInputStream(src.getInputStream());
            }
            catch (IOException ex) {
                throw new BuildException("problem opening " + this.srcFile, ex);
            }
            while ((entry = ti.getNextEntry()) != null) {
                TarResource r = new TarResource(src, entry);
                String name = entry.getName();
                if (entry.isDirectory()) {
                    name = TarScanner.trimSeparator(name);
                    dirEntries.put(name, r);
                    if (!this.match(name)) continue;
                    matchDirEntries.put(name, r);
                    continue;
                }
                fileEntries.put(name, r);
                if (!this.match(name)) continue;
                matchFileEntries.put(name, r);
            }
        }
        catch (IOException ex) {
            try {
                throw new BuildException("problem reading " + this.srcFile, ex);
            }
            catch (Throwable throwable) {
                FileUtils.close(ti);
                throw throwable;
            }
        }
        FileUtils.close(ti);
    }
}

