/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.types;

import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.types.ArchiveScanner;
import com.bes.mq.shade.org.apache.tools.ant.types.Resource;
import com.bes.mq.shade.org.apache.tools.ant.types.resources.FileProvider;
import com.bes.mq.shade.org.apache.tools.ant.types.resources.ZipResource;
import com.bes.mq.shade.org.apache.tools.zip.ZipEntry;
import com.bes.mq.shade.org.apache.tools.zip.ZipFile;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipException;

public class ZipScanner
extends ArchiveScanner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillMapsFromArchive(Resource src, String encoding, Map fileEntries, Map matchFileEntries, Map dirEntries, Map matchDirEntries) {
        ZipEntry entry = null;
        ZipFile zf = null;
        File srcFile = null;
        FileProvider fp = (FileProvider)src.as(FileProvider.class);
        if (fp == null) {
            throw new BuildException("Only file provider resources are supported");
        }
        srcFile = fp.getFile();
        try {
            try {
                zf = new ZipFile(srcFile, encoding);
            }
            catch (ZipException ex) {
                throw new BuildException("Problem reading " + srcFile, ex);
            }
            catch (IOException ex) {
                throw new BuildException("Problem opening " + srcFile, ex);
            }
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                entry = (ZipEntry)e.nextElement();
                ZipResource r = new ZipResource(srcFile, encoding, entry);
                String name = entry.getName();
                if (entry.isDirectory()) {
                    name = ZipScanner.trimSeparator(name);
                    dirEntries.put(name, r);
                    if (!this.match(name)) continue;
                    matchDirEntries.put(name, r);
                    continue;
                }
                fileEntries.put(name, r);
                if (!this.match(name)) continue;
                matchFileEntries.put(name, r);
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly(zf);
    }
}

