/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.ant.types.resources;

import com.bes.mq.shade.org.apache.tools.ant.BuildException;
import com.bes.mq.shade.org.apache.tools.ant.types.Reference;
import com.bes.mq.shade.org.apache.tools.ant.types.Resource;
import com.bes.mq.shade.org.apache.tools.ant.types.resources.URLProvider;
import com.bes.mq.shade.org.apache.tools.ant.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URLResource
extends Resource
implements URLProvider {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final int NULL_URL = Resource.getMagicNumber("null URL".getBytes());
    private URL url;
    private URLConnection conn;
    private URL baseURL;
    private String relPath;

    public URLResource() {
    }

    public URLResource(URL u) {
        this.setURL(u);
    }

    public URLResource(URLProvider u) {
        this.setURL(u.getURL());
    }

    public URLResource(File f) {
        this.setFile(f);
    }

    public URLResource(String u) {
        this(URLResource.newURL(u));
    }

    public synchronized void setURL(URL u) {
        this.checkAttributesAllowed();
        this.url = u;
    }

    public synchronized void setFile(File f) {
        try {
            this.setURL(FILE_UTILS.getFileURL(f));
        }
        catch (MalformedURLException e) {
            throw new BuildException(e);
        }
    }

    public synchronized void setBaseURL(URL base) {
        this.checkAttributesAllowed();
        if (this.url != null) {
            throw new BuildException("can't define URL and baseURL attribute");
        }
        this.baseURL = base;
    }

    public synchronized void setRelativePath(String r) {
        this.checkAttributesAllowed();
        if (this.url != null) {
            throw new BuildException("can't define URL and relativePath attribute");
        }
        this.relPath = r;
    }

    public synchronized URL getURL() {
        if (this.isReference()) {
            return ((URLResource)this.getCheckedRef()).getURL();
        }
        if (this.url == null && this.baseURL != null) {
            if (this.relPath == null) {
                throw new BuildException("must provide relativePath attribute when using baseURL.");
            }
            try {
                this.url = new URL(this.baseURL, this.relPath);
            }
            catch (MalformedURLException e) {
                throw new BuildException(e);
            }
        }
        return this.url;
    }

    public synchronized void setRefid(Reference r) {
        if (this.url != null || this.baseURL != null || this.relPath != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public synchronized String getName() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getName();
        }
        String name = this.getURL().getFile();
        return "".equals(name) ? name : name.substring(1);
    }

    public synchronized String toString() {
        return this.isReference() ? this.getCheckedRef().toString() : String.valueOf(this.getURL());
    }

    public synchronized boolean isExists() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).isExists();
        }
        return this.isExists(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean isExists(boolean closeConnection) {
        if (this.getURL() == null) {
            return false;
        }
        try {
            this.connect(3);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (closeConnection) {
                this.close();
            }
        }
    }

    public synchronized long getLastModified() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getLastModified();
        }
        if (!this.isExists(false)) {
            return 0L;
        }
        return this.conn.getLastModified();
    }

    public synchronized boolean isDirectory() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).isDirectory() : this.getName().endsWith("/");
    }

    public synchronized long getSize() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getSize();
        }
        if (!this.isExists(false)) {
            return 0L;
        }
        try {
            this.connect();
            long contentlength = this.conn.getContentLength();
            this.close();
            return contentlength;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public synchronized boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (this.isReference()) {
            return this.getCheckedRef().equals(another);
        }
        if (!another.getClass().equals(this.getClass())) {
            return false;
        }
        URLResource otheru = (URLResource)another;
        return this.getURL() == null ? otheru.getURL() == null : this.getURL().equals(otheru.getURL());
    }

    public synchronized int hashCode() {
        if (this.isReference()) {
            return this.getCheckedRef().hashCode();
        }
        return MAGIC * (this.getURL() == null ? NULL_URL : this.getURL().hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        this.connect();
        try {
            InputStream inputStream = this.conn.getInputStream();
            return inputStream;
        }
        finally {
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        this.connect();
        try {
            OutputStream outputStream = this.conn.getOutputStream();
            return outputStream;
        }
        finally {
            this.conn = null;
        }
    }

    protected void connect() throws IOException {
        this.connect(0);
    }

    protected synchronized void connect(int logLevel) throws IOException {
        URL u = this.getURL();
        if (u == null) {
            throw new BuildException("URL not set");
        }
        if (this.conn == null) {
            try {
                this.conn = u.openConnection();
                this.conn.connect();
            }
            catch (IOException e) {
                this.log(e.toString(), logLevel);
                this.conn = null;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close() {
        try {
            FileUtils.close(this.conn);
        }
        finally {
            this.conn = null;
        }
    }

    private static URL newURL(String u) {
        try {
            return new URL(u);
        }
        catch (MalformedURLException e) {
            throw new BuildException(e);
        }
    }
}

