/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.shade.org.apache.tools.tar;

import com.bes.mq.shade.org.apache.tools.tar.TarBuffer;
import com.bes.mq.shade.org.apache.tools.tar.TarEntry;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TarInputStream
extends FilterInputStream {
    private static final int SMALL_BUFFER_SIZE = 256;
    private static final int BUFFER_SIZE = 8192;
    private static final int LARGE_BUFFER_SIZE = 32768;
    private static final int BYTE_MASK = 255;
    protected boolean debug;
    protected boolean hasHitEOF;
    protected long entrySize;
    protected long entryOffset;
    protected byte[] readBuf;
    protected TarBuffer buffer;
    protected TarEntry currEntry;
    protected byte[] oneBuf;

    public TarInputStream(InputStream is) {
        this(is, 10240, 512);
    }

    public TarInputStream(InputStream is, int blockSize) {
        this(is, blockSize, 512);
    }

    public TarInputStream(InputStream is, int blockSize, int recordSize) {
        super(is);
        this.buffer = new TarBuffer(is, blockSize, recordSize);
        this.readBuf = null;
        this.oneBuf = new byte[1];
        this.debug = false;
        this.hasHitEOF = false;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.buffer.setDebug(debug);
    }

    public void close() throws IOException {
        this.buffer.close();
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public int available() throws IOException {
        if (this.entrySize - this.entryOffset > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.entrySize - this.entryOffset);
    }

    public long skip(long numToSkip) throws IOException {
        int realSkip;
        long skip;
        int numRead;
        byte[] skipBuf = new byte[8192];
        for (skip = numToSkip; skip > 0L && (numRead = this.read(skipBuf, 0, realSkip = (int)(skip > (long)skipBuf.length ? (long)skipBuf.length : skip))) != -1; skip -= (long)numRead) {
        }
        return numToSkip - skip;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int markLimit) {
    }

    public void reset() {
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] headerBuf;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            long numToSkip = this.entrySize - this.entryOffset;
            if (this.debug) {
                System.err.println("TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + numToSkip + " bytes");
            }
            while (numToSkip > 0L) {
                long skipped = this.skip(numToSkip);
                if (skipped <= 0L) {
                    throw new RuntimeException("failed to skip current tar entry");
                }
                numToSkip -= skipped;
            }
            this.readBuf = null;
        }
        if ((headerBuf = this.buffer.readRecord()) == null) {
            if (this.debug) {
                System.err.println("READ NULL RECORD");
            }
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(headerBuf)) {
            if (this.debug) {
                System.err.println("READ EOF RECORD");
            }
            this.hasHitEOF = true;
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            this.currEntry = new TarEntry(headerBuf);
            if (this.debug) {
                System.err.println("TarInputStream: SET CURRENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize());
            }
            this.entryOffset = 0L;
            this.entrySize = this.currEntry.getSize();
        }
        if (this.currEntry != null && this.currEntry.isGNULongNameEntry()) {
            StringBuffer longName = new StringBuffer();
            byte[] buf = new byte[256];
            int length = 0;
            while ((length = this.read(buf)) >= 0) {
                longName.append(new String(buf, 0, length));
            }
            this.getNextEntry();
            if (this.currEntry == null) {
                return null;
            }
            if (longName.length() > 0 && longName.charAt(longName.length() - 1) == '\u0000') {
                longName.deleteCharAt(longName.length() - 1);
            }
            this.currEntry.setName(longName.toString());
        }
        return this.currEntry;
    }

    public int read() throws IOException {
        int num = this.read(this.oneBuf, 0, 1);
        return num == -1 ? -1 : this.oneBuf[0] & 0xFF;
    }

    public int read(byte[] buf, int offset, int numToRead) throws IOException {
        int totalRead = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)numToRead + this.entryOffset > this.entrySize) {
            numToRead = (int)(this.entrySize - this.entryOffset);
        }
        if (this.readBuf != null) {
            int sz = numToRead > this.readBuf.length ? this.readBuf.length : numToRead;
            System.arraycopy(this.readBuf, 0, buf, offset, sz);
            if (sz >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                int newLen = this.readBuf.length - sz;
                byte[] newBuf = new byte[newLen];
                System.arraycopy(this.readBuf, sz, newBuf, 0, newLen);
                this.readBuf = newBuf;
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        while (numToRead > 0) {
            byte[] rec = this.buffer.readRecord();
            if (rec == null) {
                throw new IOException("unexpected EOF with " + numToRead + " bytes unread");
            }
            int recLen = rec.length;
            int sz = numToRead;
            if (recLen > sz) {
                System.arraycopy(rec, 0, buf, offset, sz);
                this.readBuf = new byte[recLen - sz];
                System.arraycopy(rec, sz, this.readBuf, 0, recLen - sz);
            } else {
                sz = recLen;
                System.arraycopy(rec, 0, buf, offset, recLen);
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        this.entryOffset += (long)totalRead;
        return totalRead;
    }

    public void copyEntryContents(OutputStream out) throws IOException {
        int numRead;
        byte[] buf = new byte[32768];
        while ((numRead = this.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, numRead);
        }
    }
}

