/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.asn1.x509;

import com.bes.enterprise.cipher.asn1.ASN1EncodableVector;
import com.bes.enterprise.cipher.asn1.ASN1GeneralizedTime;
import com.bes.enterprise.cipher.asn1.ASN1Integer;
import com.bes.enterprise.cipher.asn1.ASN1Sequence;
import com.bes.enterprise.cipher.asn1.ASN1UTCTime;
import com.bes.enterprise.cipher.asn1.DEROctetString;
import com.bes.enterprise.cipher.asn1.DERSequence;
import com.bes.enterprise.cipher.asn1.DERTaggedObject;
import com.bes.enterprise.cipher.asn1.x500.X500Name;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.asn1.x509.CRLReason;
import com.bes.enterprise.cipher.asn1.x509.Extension;
import com.bes.enterprise.cipher.asn1.x509.Extensions;
import com.bes.enterprise.cipher.asn1.x509.TBSCertList;
import com.bes.enterprise.cipher.asn1.x509.Time;
import com.bes.enterprise.cipher.asn1.x509.X509Extensions;
import com.bes.enterprise.cipher.asn1.x509.X509Name;
import java.io.IOException;

public class V2TBSCertListGenerator {
    private ASN1Integer version = new ASN1Integer(1L);
    private AlgorithmIdentifier signature;
    private X500Name issuer;
    private Time thisUpdate;
    private Time nextUpdate = null;
    private Extensions extensions = null;
    private ASN1EncodableVector crlentries = new ASN1EncodableVector();
    private static final ASN1Sequence[] reasons = new ASN1Sequence[11];

    public void setSignature(AlgorithmIdentifier signature) {
        this.signature = signature;
    }

    public void setIssuer(X509Name issuer) {
        this.issuer = X500Name.getInstance(issuer.toASN1Primitive());
    }

    public void setIssuer(X500Name issuer) {
        this.issuer = issuer;
    }

    public void setThisUpdate(ASN1UTCTime thisUpdate) {
        this.thisUpdate = new Time(thisUpdate);
    }

    public void setNextUpdate(ASN1UTCTime nextUpdate) {
        this.nextUpdate = new Time(nextUpdate);
    }

    public void setThisUpdate(Time thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public void setNextUpdate(Time nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public void addCRLEntry(ASN1Sequence crlEntry) {
        this.crlentries.add(crlEntry);
    }

    public void addCRLEntry(ASN1Integer userCertificate, ASN1UTCTime revocationDate, int reason) {
        this.addCRLEntry(userCertificate, new Time(revocationDate), reason);
    }

    public void addCRLEntry(ASN1Integer userCertificate, Time revocationDate, int reason) {
        this.addCRLEntry(userCertificate, revocationDate, reason, null);
    }

    public void addCRLEntry(ASN1Integer userCertificate, Time revocationDate, int reason, ASN1GeneralizedTime invalidityDate) {
        if (reason != 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            if (reason < reasons.length) {
                if (reason < 0) {
                    throw new IllegalArgumentException("invalid reason value: " + reason);
                }
                v.add(reasons[reason]);
            } else {
                v.add(V2TBSCertListGenerator.createReasonExtension(reason));
            }
            if (invalidityDate != null) {
                v.add(V2TBSCertListGenerator.createInvalidityDateExtension(invalidityDate));
            }
            this.internalAddCRLEntry(userCertificate, revocationDate, new DERSequence(v));
        } else if (invalidityDate != null) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(V2TBSCertListGenerator.createInvalidityDateExtension(invalidityDate));
            this.internalAddCRLEntry(userCertificate, revocationDate, new DERSequence(v));
        } else {
            this.addCRLEntry(userCertificate, revocationDate, null);
        }
    }

    private void internalAddCRLEntry(ASN1Integer userCertificate, Time revocationDate, ASN1Sequence extensions) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(userCertificate);
        v.add(revocationDate);
        if (extensions != null) {
            v.add(extensions);
        }
        this.addCRLEntry(new DERSequence(v));
    }

    public void addCRLEntry(ASN1Integer userCertificate, Time revocationDate, Extensions extensions) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(userCertificate);
        v.add(revocationDate);
        if (extensions != null) {
            v.add(extensions);
        }
        this.addCRLEntry(new DERSequence(v));
    }

    public void setExtensions(X509Extensions extensions) {
        this.setExtensions(Extensions.getInstance(extensions));
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (this.signature == null || this.issuer == null || this.thisUpdate == null) {
            throw new IllegalStateException("Not all mandatory fields set in V2 TBSCertList generator.");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.signature);
        v.add(this.issuer);
        v.add(this.thisUpdate);
        if (this.nextUpdate != null) {
            v.add(this.nextUpdate);
        }
        if (this.crlentries.size() != 0) {
            v.add(new DERSequence(this.crlentries));
        }
        if (this.extensions != null) {
            v.add(new DERTaggedObject(0, this.extensions));
        }
        return new TBSCertList(new DERSequence(v));
    }

    private static ASN1Sequence createReasonExtension(int reasonCode) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        CRLReason crlReason = CRLReason.lookup(reasonCode);
        try {
            v.add(Extension.reasonCode);
            v.add(new DEROctetString(crlReason.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error encoding reason: " + e);
        }
        return new DERSequence(v);
    }

    private static ASN1Sequence createInvalidityDateExtension(ASN1GeneralizedTime invalidityDate) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        try {
            v.add(Extension.invalidityDate);
            v.add(new DEROctetString(invalidityDate.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error encoding reason: " + e);
        }
        return new DERSequence(v);
    }

    static {
        V2TBSCertListGenerator.reasons[0] = V2TBSCertListGenerator.createReasonExtension(0);
        V2TBSCertListGenerator.reasons[1] = V2TBSCertListGenerator.createReasonExtension(1);
        V2TBSCertListGenerator.reasons[2] = V2TBSCertListGenerator.createReasonExtension(2);
        V2TBSCertListGenerator.reasons[3] = V2TBSCertListGenerator.createReasonExtension(3);
        V2TBSCertListGenerator.reasons[4] = V2TBSCertListGenerator.createReasonExtension(4);
        V2TBSCertListGenerator.reasons[5] = V2TBSCertListGenerator.createReasonExtension(5);
        V2TBSCertListGenerator.reasons[6] = V2TBSCertListGenerator.createReasonExtension(6);
        V2TBSCertListGenerator.reasons[7] = V2TBSCertListGenerator.createReasonExtension(7);
        V2TBSCertListGenerator.reasons[8] = V2TBSCertListGenerator.createReasonExtension(8);
        V2TBSCertListGenerator.reasons[9] = V2TBSCertListGenerator.createReasonExtension(9);
        V2TBSCertListGenerator.reasons[10] = V2TBSCertListGenerator.createReasonExtension(10);
    }
}

