/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.bc;

import com.bes.enterprise.cipher.asn1.oiw.OIWObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.asn1.x509.AuthorityKeyIdentifier;
import com.bes.enterprise.cipher.asn1.x509.SubjectKeyIdentifier;
import com.bes.enterprise.cipher.cert.X509ExtensionUtils;
import com.bes.enterprise.cipher.crypto.digests.SHA1Digest;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.util.SubjectPublicKeyInfoFactory;
import com.bes.enterprise.cipher.operator.DigestCalculator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BcX509ExtensionUtils
extends X509ExtensionUtils {
    public BcX509ExtensionUtils() {
        super(new SHA1DigestCalculator());
    }

    public BcX509ExtensionUtils(DigestCalculator calculator) {
        super(calculator);
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(AsymmetricKeyParameter publicKey) throws IOException {
        return super.createAuthorityKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(publicKey));
    }

    public SubjectKeyIdentifier createSubjectKeyIdentifier(AsymmetricKeyParameter publicKey) throws IOException {
        return super.createSubjectKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(publicKey));
    }

    private static class SHA1DigestCalculator
    implements DigestCalculator {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private SHA1DigestCalculator() {
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.bOut;
        }

        @Override
        public byte[] getDigest() {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            SHA1Digest sha1 = new SHA1Digest();
            sha1.update(bytes, 0, bytes.length);
            byte[] digest = new byte[sha1.getDigestSize()];
            sha1.doFinal(digest, 0);
            return digest;
        }
    }
}

