/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.cmp;

import com.bes.enterprise.cipher.asn1.ASN1EncodableVector;
import com.bes.enterprise.cipher.asn1.DERSequence;
import com.bes.enterprise.cipher.asn1.cmp.CertConfirmContent;
import com.bes.enterprise.cipher.asn1.cmp.CertStatus;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cert.X509CertificateHolder;
import com.bes.enterprise.cipher.cert.cmp.CMPException;
import com.bes.enterprise.cipher.cert.cmp.CMPUtil;
import com.bes.enterprise.cipher.cert.cmp.CertificateConfirmationContent;
import com.bes.enterprise.cipher.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.bes.enterprise.cipher.operator.DigestAlgorithmIdentifierFinder;
import com.bes.enterprise.cipher.operator.DigestCalculator;
import com.bes.enterprise.cipher.operator.DigestCalculatorProvider;
import com.bes.enterprise.cipher.operator.OperatorCreationException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CertificateConfirmationContentBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private List acceptedCerts = new ArrayList();
    private List acceptedReqIds = new ArrayList();

    public CertificateConfirmationContentBuilder() {
        this(new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContentBuilder(DigestAlgorithmIdentifierFinder digestAlgFinder) {
        this.digestAlgFinder = digestAlgFinder;
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder certHolder, BigInteger certReqID) {
        this.acceptedCerts.add(certHolder);
        this.acceptedReqIds.add(certReqID);
        return this;
    }

    public CertificateConfirmationContent build(DigestCalculatorProvider digesterProvider) throws CMPException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i != this.acceptedCerts.size(); ++i) {
            DigestCalculator digester;
            X509CertificateHolder certHolder = (X509CertificateHolder)this.acceptedCerts.get(i);
            BigInteger reqID = (BigInteger)this.acceptedReqIds.get(i);
            AlgorithmIdentifier digAlg = this.digestAlgFinder.find(certHolder.toASN1Structure().getSignatureAlgorithm());
            if (digAlg == null) {
                throw new CMPException("cannot find algorithm for digest from signature");
            }
            try {
                digester = digesterProvider.get(digAlg);
            }
            catch (OperatorCreationException e) {
                throw new CMPException("unable to create digest: " + e.getMessage(), e);
            }
            CMPUtil.derEncodeToStream(certHolder.toASN1Structure(), digester.getOutputStream());
            v.add(new CertStatus(digester.getDigest(), reqID));
        }
        return new CertificateConfirmationContent(CertConfirmContent.getInstance(new DERSequence(v)), this.digestAlgFinder);
    }
}

