/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.cmp;

import com.bes.enterprise.cipher.asn1.cmp.CertStatus;
import com.bes.enterprise.cipher.asn1.cmp.PKIStatusInfo;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cert.X509CertificateHolder;
import com.bes.enterprise.cipher.cert.cmp.CMPException;
import com.bes.enterprise.cipher.cert.cmp.CMPUtil;
import com.bes.enterprise.cipher.operator.DigestAlgorithmIdentifierFinder;
import com.bes.enterprise.cipher.operator.DigestCalculator;
import com.bes.enterprise.cipher.operator.DigestCalculatorProvider;
import com.bes.enterprise.cipher.operator.OperatorCreationException;
import com.bes.enterprise.cipher.util.Arrays;
import java.math.BigInteger;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder certHolder, DigestCalculatorProvider digesterProvider) throws CMPException {
        DigestCalculator digester;
        AlgorithmIdentifier digAlg = this.digestAlgFinder.find(certHolder.toASN1Structure().getSignatureAlgorithm());
        if (digAlg == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digester = digesterProvider.get(digAlg);
        }
        catch (OperatorCreationException e) {
            throw new CMPException("unable to create digester: " + e.getMessage(), e);
        }
        CMPUtil.derEncodeToStream(certHolder.toASN1Structure(), digester.getOutputStream());
        return Arrays.areEqual(this.certStatus.getCertHash().getOctets(), digester.getDigest());
    }
}

