/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.crmf;

import com.bes.enterprise.cipher.asn1.crmf.EncryptedValue;
import com.bes.enterprise.cipher.asn1.pkcs.PrivateKeyInfo;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.asn1.x509.Certificate;
import com.bes.enterprise.cipher.cert.X509CertificateHolder;
import com.bes.enterprise.cipher.cert.crmf.CRMFException;
import com.bes.enterprise.cipher.cert.crmf.EncryptedValuePadder;
import com.bes.enterprise.cipher.cert.crmf.ValueDecryptorGenerator;
import com.bes.enterprise.cipher.operator.InputDecryptor;
import com.bes.enterprise.cipher.util.Strings;
import com.bes.enterprise.cipher.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedValueParser {
    private EncryptedValue value;
    private EncryptedValuePadder padder;

    public EncryptedValueParser(EncryptedValue value) {
        this.value = value;
    }

    public EncryptedValueParser(EncryptedValue value, EncryptedValuePadder padder) {
        this.value = value;
        this.padder = padder;
    }

    public AlgorithmIdentifier getIntendedAlg() {
        return this.value.getIntendedAlg();
    }

    private byte[] decryptValue(ValueDecryptorGenerator decGen) throws CRMFException {
        if (this.value.getValueHint() != null) {
            throw new UnsupportedOperationException();
        }
        InputDecryptor decryptor = decGen.getValueDecryptor(this.value.getKeyAlg(), this.value.getSymmAlg(), this.value.getEncSymmKey().getBytes());
        InputStream dataIn = decryptor.getInputStream(new ByteArrayInputStream(this.value.getEncValue().getBytes()));
        try {
            byte[] data = Streams.readAll(dataIn);
            if (this.padder != null) {
                return this.padder.getUnpaddedData(data);
            }
            return data;
        }
        catch (IOException e) {
            throw new CRMFException("Cannot parse decrypted data: " + e.getMessage(), e);
        }
    }

    public X509CertificateHolder readCertificateHolder(ValueDecryptorGenerator decGen) throws CRMFException {
        return new X509CertificateHolder(Certificate.getInstance(this.decryptValue(decGen)));
    }

    public PrivateKeyInfo readPrivateKeyInfo(ValueDecryptorGenerator decGen) throws CRMFException {
        return PrivateKeyInfo.getInstance(this.decryptValue(decGen));
    }

    public char[] readPassphrase(ValueDecryptorGenerator decGen) throws CRMFException {
        return Strings.fromUTF8ByteArray(this.decryptValue(decGen)).toCharArray();
    }
}

