/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.crmf;

import com.bes.enterprise.cipher.asn1.DERBitString;
import com.bes.enterprise.cipher.asn1.crmf.PKMACValue;
import com.bes.enterprise.cipher.asn1.x509.SubjectPublicKeyInfo;
import com.bes.enterprise.cipher.cert.crmf.CRMFException;
import com.bes.enterprise.cipher.cert.crmf.PKMACBuilder;
import com.bes.enterprise.cipher.operator.MacCalculator;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueGenerator {
    private PKMACBuilder builder;

    public PKMACValueGenerator(PKMACBuilder builder) {
        this.builder = builder;
    }

    public PKMACValue generate(char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return new PKMACValue(calculator.getAlgorithmIdentifier(), new DERBitString(calculator.getMac()));
    }
}

