/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.crmf;

import com.bes.enterprise.cipher.asn1.cmp.PBMParameter;
import com.bes.enterprise.cipher.asn1.crmf.PKMACValue;
import com.bes.enterprise.cipher.asn1.x509.SubjectPublicKeyInfo;
import com.bes.enterprise.cipher.cert.crmf.CRMFException;
import com.bes.enterprise.cipher.cert.crmf.PKMACBuilder;
import com.bes.enterprise.cipher.operator.MacCalculator;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder builder) {
        this.builder = builder;
    }

    public boolean isValid(PKMACValue value, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(value.getAlgId().getParameters()));
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return Arrays.areEqual(calculator.getMac(), value.getValue().getBytes());
    }
}

