/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.crmf.jcajce;

import com.bes.enterprise.cipher.asn1.crmf.EncryptedValue;
import com.bes.enterprise.cipher.asn1.pkcs.PrivateKeyInfo;
import com.bes.enterprise.cipher.cert.crmf.CRMFException;
import com.bes.enterprise.cipher.cert.crmf.EncryptedValueBuilder;
import com.bes.enterprise.cipher.cert.jcajce.JcaX509CertificateHolder;
import com.bes.enterprise.cipher.operator.KeyWrapper;
import com.bes.enterprise.cipher.operator.OutputEncryptor;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaEncryptedValueBuilder
extends EncryptedValueBuilder {
    public JcaEncryptedValueBuilder(KeyWrapper wrapper, OutputEncryptor encryptor) {
        super(wrapper, encryptor);
    }

    public EncryptedValue build(X509Certificate certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(certificate));
    }

    public EncryptedValue build(PrivateKey privateKey) throws CertificateEncodingException, CRMFException {
        return this.build(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

