/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.crmf.jcajce;

import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cert.crmf.CRMFException;
import com.bes.enterprise.cipher.cert.crmf.PKMACValuesCalculator;
import com.bes.enterprise.cipher.cert.crmf.jcajce.CRMFHelper;
import com.bes.enterprise.cipher.jcajce.util.DefaultJcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.NamedJcaJceHelper;
import com.bes.enterprise.cipher.jcajce.util.ProviderJcaJceHelper;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class JcePKMACValuesCalculator
implements PKMACValuesCalculator {
    private MessageDigest digest;
    private Mac mac;
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());

    public JcePKMACValuesCalculator setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePKMACValuesCalculator setProvider(String providerName) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    @Override
    public void setup(AlgorithmIdentifier digAlg, AlgorithmIdentifier macAlg) throws CRMFException {
        this.digest = this.helper.createDigest(digAlg.getAlgorithm());
        this.mac = this.helper.createMac(macAlg.getAlgorithm());
    }

    @Override
    public byte[] calculateDigest(byte[] data) {
        return this.digest.digest(data);
    }

    @Override
    public byte[] calculateMac(byte[] pwd, byte[] data) throws CRMFException {
        try {
            this.mac.init(new SecretKeySpec(pwd, this.mac.getAlgorithm()));
            return this.mac.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new CRMFException("failure in setup: " + e.getMessage(), e);
        }
    }
}

