/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.dane;

import com.bes.enterprise.cipher.cert.dane.DANEEntrySelector;
import com.bes.enterprise.cipher.cert.dane.DANEException;
import com.bes.enterprise.cipher.operator.DigestCalculator;
import com.bes.enterprise.cipher.util.Strings;
import com.bes.enterprise.cipher.util.encoders.Hex;
import java.io.IOException;
import java.io.OutputStream;

public class DANEEntrySelectorFactory {
    private final DigestCalculator digestCalculator;

    public DANEEntrySelectorFactory(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public DANEEntrySelector createSelector(String emailAddress) throws DANEException {
        byte[] enc = Strings.toUTF8ByteArray(emailAddress.substring(0, emailAddress.indexOf(64)));
        try {
            OutputStream cOut = this.digestCalculator.getOutputStream();
            cOut.write(enc);
            cOut.close();
        }
        catch (IOException e) {
            throw new DANEException("Unable to calculate digest string: " + e.getMessage(), e);
        }
        byte[] hash = this.digestCalculator.getDigest();
        String domainName = Strings.fromByteArray(Hex.encode(hash)) + "._smimecert." + emailAddress.substring(emailAddress.indexOf(64) + 1);
        return new DANEEntrySelector(domainName);
    }
}

