/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.dane;

import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.operator.DigestCalculator;
import java.io.OutputStream;

public class TruncatingDigestCalculator
implements DigestCalculator {
    private final DigestCalculator baseCalculator;
    private final int length;

    public TruncatingDigestCalculator(DigestCalculator baseCalculator) {
        this(baseCalculator, 28);
    }

    public TruncatingDigestCalculator(DigestCalculator baseCalculator, int length) {
        this.baseCalculator = baseCalculator;
        this.length = length;
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.baseCalculator.getAlgorithmIdentifier();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.baseCalculator.getOutputStream();
    }

    @Override
    public byte[] getDigest() {
        byte[] rv = new byte[this.length];
        byte[] dig = this.baseCalculator.getDigest();
        System.arraycopy(dig, 0, rv, 0, rv.length);
        return rv;
    }
}

