/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.path;

import com.bes.enterprise.cipher.cert.path.CertPathValidationContext;
import com.bes.enterprise.cipher.cert.path.CertPathValidationException;
import com.bes.enterprise.cipher.cert.path.CertPathValidationResult;
import com.bes.enterprise.cipher.util.Integers;
import java.util.ArrayList;
import java.util.List;

class CertPathValidationResultBuilder {
    private final CertPathValidationContext context;
    private final List<Integer> certIndexes = new ArrayList<Integer>();
    private final List<Integer> ruleIndexes = new ArrayList<Integer>();
    private final List<CertPathValidationException> exceptions = new ArrayList<CertPathValidationException>();

    CertPathValidationResultBuilder(CertPathValidationContext context) {
        this.context = context;
    }

    public CertPathValidationResult build() {
        if (this.exceptions.isEmpty()) {
            return new CertPathValidationResult(this.context);
        }
        return new CertPathValidationResult(this.context, this.toInts(this.certIndexes), this.toInts(this.ruleIndexes), this.exceptions.toArray(new CertPathValidationException[this.exceptions.size()]));
    }

    public void addException(int certIndex, int ruleIndex, CertPathValidationException exception) {
        this.certIndexes.add(Integers.valueOf(certIndex));
        this.ruleIndexes.add(Integers.valueOf(ruleIndex));
        this.exceptions.add(exception);
    }

    private int[] toInts(List<Integer> values) {
        int[] rv = new int[values.size()];
        for (int i = 0; i != rv.length; ++i) {
            rv[i] = values.get(i);
        }
        return rv;
    }
}

