/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.path.validations;

import com.bes.enterprise.cipher.asn1.x509.Extension;
import com.bes.enterprise.cipher.asn1.x509.KeyUsage;
import com.bes.enterprise.cipher.cert.X509CertificateHolder;
import com.bes.enterprise.cipher.cert.path.CertPathValidation;
import com.bes.enterprise.cipher.cert.path.CertPathValidationContext;
import com.bes.enterprise.cipher.cert.path.CertPathValidationException;
import com.bes.enterprise.cipher.util.Memoable;

public class KeyUsageValidation
implements CertPathValidation {
    private boolean isMandatory;

    public KeyUsageValidation() {
        this(true);
    }

    public KeyUsageValidation(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    @Override
    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        context.addHandledExtension(Extension.keyUsage);
        if (!context.isEndEntity()) {
            KeyUsage usage = KeyUsage.fromExtensions(certificate.getExtensions());
            if (usage != null) {
                if (!usage.hasUsages(4)) {
                    throw new CertPathValidationException("Issuer certificate KeyUsage extension does not permit key signing");
                }
            } else if (this.isMandatory) {
                throw new CertPathValidationException("KeyUsage extension not present in CA certificate");
            }
        }
    }

    @Override
    public Memoable copy() {
        return new KeyUsageValidation(this.isMandatory);
    }

    @Override
    public void reset(Memoable other) {
        KeyUsageValidation v = (KeyUsageValidation)other;
        this.isMandatory = v.isMandatory;
    }
}

