/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cert.selector.jcajce;

import com.bes.enterprise.cipher.asn1.ASN1OctetString;
import com.bes.enterprise.cipher.asn1.x500.X500Name;
import com.bes.enterprise.cipher.asn1.x509.Extension;
import com.bes.enterprise.cipher.cert.selector.X509CertificateHolderSelector;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class JcaX509CertificateHolderSelector
extends X509CertificateHolderSelector {
    public JcaX509CertificateHolderSelector(X509Certificate certificate) {
        super(JcaX509CertificateHolderSelector.convertPrincipal(certificate.getIssuerX500Principal()), certificate.getSerialNumber(), JcaX509CertificateHolderSelector.getSubjectKeyId(certificate));
    }

    public JcaX509CertificateHolderSelector(X500Principal issuer, BigInteger serialNumber) {
        super(JcaX509CertificateHolderSelector.convertPrincipal(issuer), serialNumber);
    }

    public JcaX509CertificateHolderSelector(X500Principal issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        super(JcaX509CertificateHolderSelector.convertPrincipal(issuer), serialNumber, subjectKeyId);
    }

    private static X500Name convertPrincipal(X500Principal issuer) {
        if (issuer == null) {
            return null;
        }
        return X500Name.getInstance(issuer.getEncoded());
    }

    private static byte[] getSubjectKeyId(X509Certificate cert) {
        byte[] ext = cert.getExtensionValue(Extension.subjectKeyIdentifier.getId());
        if (ext != null) {
            return ASN1OctetString.getInstance(ASN1OctetString.getInstance(ext).getOctets()).getOctets();
        }
        return null;
    }
}

