/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cmc;

import com.bes.enterprise.cipher.asn1.ASN1Primitive;
import com.bes.enterprise.cipher.asn1.cms.ContentInfo;
import com.bes.enterprise.cipher.cert.X509CRLHolder;
import com.bes.enterprise.cipher.cert.X509CertificateHolder;
import com.bes.enterprise.cipher.cmc.CMCException;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.CMSSignedData;
import com.bes.enterprise.cipher.util.Encodable;
import com.bes.enterprise.cipher.util.Store;
import java.io.IOException;

public class SimplePKIResponse
implements Encodable {
    private final CMSSignedData certificateResponse;

    private static ContentInfo parseBytes(byte[] responseEncoding) throws CMCException {
        try {
            return ContentInfo.getInstance(ASN1Primitive.fromByteArray(responseEncoding));
        }
        catch (Exception e) {
            throw new CMCException("malformed data: " + e.getMessage(), e);
        }
    }

    public SimplePKIResponse(byte[] responseEncoding) throws CMCException {
        this(SimplePKIResponse.parseBytes(responseEncoding));
    }

    public SimplePKIResponse(ContentInfo signedData) throws CMCException {
        try {
            this.certificateResponse = new CMSSignedData(signedData);
        }
        catch (CMSException e) {
            throw new CMCException("malformed response: " + e.getMessage(), e);
        }
        if (this.certificateResponse.getSignerInfos().size() != 0) {
            throw new CMCException("malformed response: SignerInfo structures found");
        }
        if (this.certificateResponse.getSignedContent() != null) {
            throw new CMCException("malformed response: Signed Content found");
        }
    }

    public Store<X509CertificateHolder> getCertificates() {
        return this.certificateResponse.getCertificates();
    }

    public Store<X509CRLHolder> getCRLs() {
        return this.certificateResponse.getCRLs();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certificateResponse.getEncoded();
    }
}

