/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.ASN1OctetString;
import com.bes.enterprise.cipher.asn1.cms.ContentInfo;
import com.bes.enterprise.cipher.asn1.cms.DigestedData;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.CMSProcessable;
import com.bes.enterprise.cipher.cms.CMSProcessableByteArray;
import com.bes.enterprise.cipher.cms.CMSUtils;
import com.bes.enterprise.cipher.operator.DigestCalculator;
import com.bes.enterprise.cipher.operator.DigestCalculatorProvider;
import com.bes.enterprise.cipher.operator.OperatorCreationException;
import com.bes.enterprise.cipher.util.Arrays;
import com.bes.enterprise.cipher.util.Encodable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSDigestedData
implements Encodable {
    private ContentInfo contentInfo;
    private DigestedData digestedData;

    public CMSDigestedData(byte[] compressedData) throws CMSException {
        this(CMSUtils.readContentInfo(compressedData));
    }

    public CMSDigestedData(InputStream compressedData) throws CMSException {
        this(CMSUtils.readContentInfo(compressedData));
    }

    public CMSDigestedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            this.digestedData = DigestedData.getInstance(contentInfo.getContent());
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentInfo.getContentType();
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestedData.getDigestAlgorithm();
    }

    public CMSProcessable getDigestedContent() throws CMSException {
        ContentInfo content = this.digestedData.getEncapContentInfo();
        try {
            return new CMSProcessableByteArray(content.getContentType(), ((ASN1OctetString)content.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new CMSException("exception reading digested stream.", e);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public boolean verify(DigestCalculatorProvider calculatorProvider) throws CMSException {
        try {
            ContentInfo content = this.digestedData.getEncapContentInfo();
            DigestCalculator calc = calculatorProvider.get(this.digestedData.getDigestAlgorithm());
            OutputStream dOut = calc.getOutputStream();
            dOut.write(((ASN1OctetString)content.getContent()).getOctets());
            return Arrays.areEqual(this.digestedData.getDigest(), calc.getDigest());
        }
        catch (OperatorCreationException e) {
            throw new CMSException("unable to create digest calculator: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CMSException("unable process content: " + e.getMessage(), e);
        }
    }
}

