/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.cms.CMSObjectIdentifiers;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.CMSReadable;
import com.bes.enterprise.cipher.cms.CMSTypedData;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSProcessableByteArray
implements CMSTypedData,
CMSReadable {
    private final ASN1ObjectIdentifier type;
    private final byte[] bytes;

    public CMSProcessableByteArray(byte[] bytes) {
        this(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), bytes);
    }

    public CMSProcessableByteArray(ASN1ObjectIdentifier type, byte[] bytes) {
        this.type = type;
        this.bytes = bytes;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public void write(OutputStream zOut) throws IOException, CMSException {
        zOut.write(this.bytes);
    }

    @Override
    public Object getContent() {
        return Arrays.clone(this.bytes);
    }

    @Override
    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }
}

