/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms;

import com.bes.enterprise.cipher.asn1.ASN1EncodableVector;
import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.ASN1Set;
import com.bes.enterprise.cipher.asn1.BEROctetString;
import com.bes.enterprise.cipher.asn1.DERSet;
import com.bes.enterprise.cipher.asn1.cms.CMSObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.cms.ContentInfo;
import com.bes.enterprise.cipher.asn1.cms.SignedData;
import com.bes.enterprise.cipher.asn1.cms.SignerInfo;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.CMSProcessable;
import com.bes.enterprise.cipher.cms.CMSProcessableByteArray;
import com.bes.enterprise.cipher.cms.CMSSignedData;
import com.bes.enterprise.cipher.cms.CMSSignedGenerator;
import com.bes.enterprise.cipher.cms.CMSSignedHelper;
import com.bes.enterprise.cipher.cms.CMSTypedData;
import com.bes.enterprise.cipher.cms.CMSUtils;
import com.bes.enterprise.cipher.cms.SignerInfoGenerator;
import com.bes.enterprise.cipher.cms.SignerInformation;
import com.bes.enterprise.cipher.cms.SignerInformationStore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedData generate(CMSTypedData content) throws CMSException {
        return this.generate(content, false);
    }

    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            signerInfos.add(signer.toASN1Structure());
        }
        ASN1ObjectIdentifier contentTypeOID = content.getContentType();
        BEROctetString octs = null;
        if (content.getContent() != null) {
            ByteArrayOutputStream bOut = null;
            if (encapsulate) {
                bOut = new ByteArrayOutputStream();
            }
            OutputStream cOut = CMSUtils.attachSignersToOutputStream(this.signerGens, bOut);
            cOut = CMSUtils.getSafeOutputStream(cOut);
            try {
                content.write(cOut);
                cOut.close();
            }
            catch (IOException e) {
                throw new CMSException("data processing exception: " + e.getMessage(), e);
            }
            if (encapsulate) {
                octs = new BEROctetString(bOut.toByteArray());
            }
        }
        for (SignerInfoGenerator sGen : this.signerGens) {
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add(inf.getDigestAlgorithm());
            signerInfos.add(inf);
            byte[] calcDigest = sGen.getCalculatedDigest();
            if (calcDigest == null) continue;
            this.digests.put(inf.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, sd);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer) throws CMSException {
        return this.generate(new CMSProcessableByteArray(null, signer.getSignature()), false).getSignerInfos();
    }
}

