/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms;

import com.bes.enterprise.cipher.cms.KEKRecipientInformation;
import com.bes.enterprise.cipher.cms.RecipientId;
import com.bes.enterprise.cipher.util.Arrays;

public class KEKRecipientId
extends RecipientId {
    private byte[] keyIdentifier;

    public KEKRecipientId(byte[] keyIdentifier) {
        super(1);
        this.keyIdentifier = keyIdentifier;
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyIdentifier);
    }

    public boolean equals(Object o) {
        if (!(o instanceof KEKRecipientId)) {
            return false;
        }
        KEKRecipientId id = (KEKRecipientId)o;
        return Arrays.areEqual(this.keyIdentifier, id.keyIdentifier);
    }

    public byte[] getKeyIdentifier() {
        return Arrays.clone(this.keyIdentifier);
    }

    @Override
    public Object clone() {
        return new KEKRecipientId(this.keyIdentifier);
    }

    public boolean match(Object obj) {
        if (obj instanceof byte[]) {
            return Arrays.areEqual(this.keyIdentifier, (byte[])obj);
        }
        if (obj instanceof KEKRecipientInformation) {
            return ((KEKRecipientInformation)obj).getRID().equals(this);
        }
        return false;
    }
}

