/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms;

import com.bes.enterprise.cipher.asn1.DEROctetString;
import com.bes.enterprise.cipher.asn1.cms.KEKIdentifier;
import com.bes.enterprise.cipher.asn1.cms.KEKRecipientInfo;
import com.bes.enterprise.cipher.asn1.cms.RecipientInfo;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.RecipientInfoGenerator;
import com.bes.enterprise.cipher.operator.GenericKey;
import com.bes.enterprise.cipher.operator.OperatorException;
import com.bes.enterprise.cipher.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kekIdentifier, SymmetricKeyWrapper wrapper) {
        this.kekIdentifier = kekIdentifier;
        this.wrapper = wrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        try {
            DEROctetString encryptedKey = new DEROctetString(this.wrapper.generateWrappedKey(contentEncryptionKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), encryptedKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
    }
}

