/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms;

import com.bes.enterprise.cipher.asn1.cms.KEKIdentifier;
import com.bes.enterprise.cipher.asn1.cms.KEKRecipientInfo;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cms.AuthAttributesProvider;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.CMSSecureReadable;
import com.bes.enterprise.cipher.cms.KEKRecipient;
import com.bes.enterprise.cipher.cms.KEKRecipientId;
import com.bes.enterprise.cipher.cms.Recipient;
import com.bes.enterprise.cipher.cms.RecipientInformation;
import com.bes.enterprise.cipher.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

