/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms.bc;

import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.KEKRecipient;
import com.bes.enterprise.cipher.cms.bc.CMSUtils;
import com.bes.enterprise.cipher.crypto.CipherParameters;
import com.bes.enterprise.cipher.operator.OperatorException;
import com.bes.enterprise.cipher.operator.SymmetricKeyUnwrapper;
import com.bes.enterprise.cipher.operator.bc.BcSymmetricKeyUnwrapper;

public abstract class BcKEKRecipient
implements KEKRecipient {
    private SymmetricKeyUnwrapper unwrapper;

    public BcKEKRecipient(BcSymmetricKeyUnwrapper unwrapper) {
        this.unwrapper = unwrapper;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        try {
            return CMSUtils.getBcKey(this.unwrapper.generateUnwrappedKey(contentEncryptionAlgorithm, encryptedContentEncryptionKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

