/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms.bc;

import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.KeyTransRecipient;
import com.bes.enterprise.cipher.cms.bc.CMSUtils;
import com.bes.enterprise.cipher.crypto.CipherParameters;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.operator.OperatorException;
import com.bes.enterprise.cipher.operator.bc.BcRSAAsymmetricKeyUnwrapper;

public abstract class BcKeyTransRecipient
implements KeyTransRecipient {
    private AsymmetricKeyParameter recipientKey;

    public BcKeyTransRecipient(AsymmetricKeyParameter recipientKey) {
        this.recipientKey = recipientKey;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedEncryptionKey) throws CMSException {
        BcRSAAsymmetricKeyUnwrapper unwrapper = new BcRSAAsymmetricKeyUnwrapper(keyEncryptionAlgorithm, this.recipientKey);
        try {
            return CMSUtils.getBcKey(unwrapper.generateUnwrappedKey(encryptedKeyAlgorithm, encryptedEncryptionKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

