/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms.bc;

import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.RecipientOperator;
import com.bes.enterprise.cipher.cms.bc.BcKeyTransRecipient;
import com.bes.enterprise.cipher.cms.bc.EnvelopedDataHelper;
import com.bes.enterprise.cipher.crypto.BufferedBlockCipher;
import com.bes.enterprise.cipher.crypto.CipherParameters;
import com.bes.enterprise.cipher.crypto.StreamCipher;
import com.bes.enterprise.cipher.crypto.io.CipherInputStream;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.operator.InputDecryptor;
import java.io.InputStream;

public class BcRSAKeyTransEnvelopedRecipient
extends BcKeyTransRecipient {
    public BcRSAKeyTransEnvelopedRecipient(AsymmetricKeyParameter key) {
        super(key);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        CipherParameters secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataIn) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataIn, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataIn, (StreamCipher)dataCipher);
            }
        });
    }
}

