/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms.jcajce;

import com.bes.enterprise.cipher.asn1.ASN1OctetString;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.asn1.x509.SubjectPublicKeyInfo;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.RecipientOperator;
import com.bes.enterprise.cipher.cms.jcajce.JceKeyAgreeRecipient;
import com.bes.enterprise.cipher.jcajce.io.CipherInputStream;
import com.bes.enterprise.cipher.operator.InputDecryptor;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Cipher;

public class JceKeyAgreeEnvelopedRecipient
extends JceKeyAgreeRecipient {
    public JceKeyAgreeEnvelopedRecipient(PrivateKey recipientKey) {
        super(recipientKey);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, SubjectPublicKeyInfo senderPublicKey, ASN1OctetString userKeyingMaterial, byte[] encryptedContentKey) throws CMSException {
        Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, senderPublicKey, userKeyingMaterial, encryptedContentKey);
        final Cipher dataCipher = this.contentHelper.createContentCipher(secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataOut) {
                return new CipherInputStream(dataOut, dataCipher);
            }
        });
    }
}

