/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms.jcajce;

import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.cryptopro.Gost2814789EncryptedKey;
import com.bes.enterprise.cipher.asn1.cryptopro.GostR3410KeyTransport;
import com.bes.enterprise.cipher.asn1.cryptopro.GostR3410TransportParameters;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.KeyTransRecipient;
import com.bes.enterprise.cipher.cms.jcajce.CMSUtils;
import com.bes.enterprise.cipher.cms.jcajce.DefaultJcaJceExtHelper;
import com.bes.enterprise.cipher.cms.jcajce.EnvelopedDataHelper;
import com.bes.enterprise.cipher.cms.jcajce.NamedJcaJceExtHelper;
import com.bes.enterprise.cipher.cms.jcajce.ProviderJcaJceExtHelper;
import com.bes.enterprise.cipher.jcajce.spec.GOST28147WrapParameterSpec;
import com.bes.enterprise.cipher.jcajce.spec.UserKeyingMaterialSpec;
import com.bes.enterprise.cipher.operator.OperatorException;
import com.bes.enterprise.cipher.operator.jcajce.JceAsymmetricKeyUnwrapper;
import com.bes.enterprise.cipher.util.Arrays;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;

public abstract class JceKeyTransRecipient
implements KeyTransRecipient {
    private PrivateKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    protected Map extraMappings;
    protected boolean validateKeySize;
    protected boolean unwrappedKeyMustBeEncodable;

    public JceKeyTransRecipient(PrivateKey recipientKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.extraMappings = new HashMap();
        this.validateKeySize = false;
        this.recipientKey = recipientKey;
    }

    public JceKeyTransRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyTransRecipient setProvider(String providerName) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyTransRecipient setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        this.extraMappings.put(algorithm, algorithmName);
        return this;
    }

    public JceKeyTransRecipient setContentProvider(Provider provider) {
        this.contentHelper = CMSUtils.createContentHelper(provider);
        return this;
    }

    public JceKeyTransRecipient setMustProduceEncodableUnwrappedKey(boolean unwrappedKeyMustBeEncodable) {
        this.unwrappedKeyMustBeEncodable = unwrappedKeyMustBeEncodable;
        return this;
    }

    public JceKeyTransRecipient setContentProvider(String providerName) {
        this.contentHelper = CMSUtils.createContentHelper(providerName);
        return this;
    }

    public JceKeyTransRecipient setKeySizeValidation(boolean doValidate) {
        this.validateKeySize = doValidate;
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedEncryptionKey) throws CMSException {
        if (CMSUtils.isGOST(keyEncryptionAlgorithm.getAlgorithm())) {
            try {
                GostR3410KeyTransport transport = GostR3410KeyTransport.getInstance(encryptedEncryptionKey);
                GostR3410TransportParameters transParams = transport.getTransportParameters();
                KeyFactory keyFactory = this.helper.createKeyFactory(keyEncryptionAlgorithm.getAlgorithm());
                PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(transParams.getEphemeralPublicKey().getEncoded()));
                KeyAgreement agreement = this.helper.createKeyAgreement(keyEncryptionAlgorithm.getAlgorithm());
                agreement.init((Key)this.recipientKey, new UserKeyingMaterialSpec(transParams.getUkm()));
                agreement.doPhase(pubKey, true);
                SecretKey key = agreement.generateSecret(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_KeyWrap.getId());
                Cipher keyCipher = this.helper.createCipher(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_KeyWrap);
                keyCipher.init(4, (Key)key, new GOST28147WrapParameterSpec(transParams.getEncryptionParamSet(), transParams.getUkm()));
                Gost2814789EncryptedKey encKey = transport.getSessionEncryptedKey();
                return keyCipher.unwrap(Arrays.concatenate(encKey.getEncryptedKey(), encKey.getMacKey()), this.helper.getBaseCipherName(encryptedKeyAlgorithm.getAlgorithm()), 3);
            }
            catch (Exception e) {
                throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
            }
        }
        JceAsymmetricKeyUnwrapper unwrapper = this.helper.createAsymmetricUnwrapper(keyEncryptionAlgorithm, this.recipientKey).setMustProduceEncodableUnwrappedKey(this.unwrappedKeyMustBeEncodable);
        if (!this.extraMappings.isEmpty()) {
            for (ASN1ObjectIdentifier algorithm : this.extraMappings.keySet()) {
                unwrapper.setAlgorithmMapping(algorithm, (String)this.extraMappings.get(algorithm));
            }
        }
        try {
            Key key = this.helper.getJceKey(encryptedKeyAlgorithm.getAlgorithm(), unwrapper.generateUnwrappedKey(encryptedKeyAlgorithm, encryptedEncryptionKey));
            if (this.validateKeySize) {
                this.helper.keySizeCheck(encryptedKeyAlgorithm, key);
            }
            return key;
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

