/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.cms.jcajce;

import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.cms.CMSException;
import com.bes.enterprise.cipher.cms.RecipientOperator;
import com.bes.enterprise.cipher.cms.jcajce.JcePasswordRecipient;
import com.bes.enterprise.cipher.jcajce.io.CipherInputStream;
import com.bes.enterprise.cipher.operator.InputDecryptor;
import java.io.InputStream;
import java.security.Key;
import javax.crypto.Cipher;

public class JcePasswordEnvelopedRecipient
extends JcePasswordRecipient {
    public JcePasswordEnvelopedRecipient(char[] password) {
        super(password);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] derivedKey, byte[] encryptedContentEncryptionKey) throws CMSException {
        Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, derivedKey, encryptedContentEncryptionKey);
        final Cipher dataCipher = this.helper.createContentCipher(secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataOut) {
                return new CipherInputStream(dataOut, dataCipher);
            }
        });
    }
}

