/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.tls;

import com.bes.enterprise.cipher.crypto.Digest;
import com.bes.enterprise.cipher.crypto.Signer;
import com.bes.enterprise.cipher.crypto.params.ECDomainParameters;
import com.bes.enterprise.cipher.crypto.tls.CertificateRequest;
import com.bes.enterprise.cipher.crypto.tls.DigestInputBuffer;
import com.bes.enterprise.cipher.crypto.tls.DigitallySigned;
import com.bes.enterprise.cipher.crypto.tls.SecurityParameters;
import com.bes.enterprise.cipher.crypto.tls.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.crypto.tls.SignerInputBuffer;
import com.bes.enterprise.cipher.crypto.tls.TlsCredentials;
import com.bes.enterprise.cipher.crypto.tls.TlsECCUtils;
import com.bes.enterprise.cipher.crypto.tls.TlsECDHKeyExchange;
import com.bes.enterprise.cipher.crypto.tls.TlsFatalAlert;
import com.bes.enterprise.cipher.crypto.tls.TlsSigner;
import com.bes.enterprise.cipher.crypto.tls.TlsSignerCredentials;
import com.bes.enterprise.cipher.crypto.tls.TlsUtils;
import com.bes.enterprise.cipher.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsECDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, int[] namedCurves, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(keyExchange, supportedSignatureAlgorithms, namedCurves, clientECPointFormats, serverECPointFormats);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer buf = new DigestInputBuffer();
        this.ecAgreePrivateKey = TlsECCUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.namedCurves, this.clientECPointFormats, buf);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.context, this.serverCredentials);
        Digest d = TlsUtils.createHash(signatureAndHashAlgorithm);
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        d.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        d.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        buf.updateDigest(d);
        byte[] hash = new byte[d.getDigestSize()];
        d.doFinal(hash, 0);
        byte[] signature = this.serverCredentials.generateCertificateSignature(hash);
        DigitallySigned signed_params = new DigitallySigned(signatureAndHashAlgorithm, signature);
        signed_params.encode(buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer buf = new SignerInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, buf);
        ECDomainParameters curve_params = TlsECCUtils.readECParameters(this.namedCurves, this.clientECPointFormats, teeIn);
        byte[] point = TlsUtils.readOpaque8(teeIn);
        DigitallySigned signed_params = this.parseSignature(input);
        Signer signer = this.initVerifyer(this.tlsSigner, signed_params.getAlgorithm(), securityParameters);
        buf.updateSigner(signer);
        if (!signer.verifySignature(signed_params.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.ecAgreePublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.clientECPointFormats, curve_params, point));
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm algorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(algorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

