/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.dvcs;

import com.bes.enterprise.cipher.asn1.ASN1Encodable;
import com.bes.enterprise.cipher.asn1.ASN1OctetString;
import com.bes.enterprise.cipher.asn1.ASN1Sequence;
import com.bes.enterprise.cipher.asn1.cms.ContentInfo;
import com.bes.enterprise.cipher.asn1.cms.SignedData;
import com.bes.enterprise.cipher.asn1.dvcs.DVCSObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.dvcs.ServiceType;
import com.bes.enterprise.cipher.asn1.x509.GeneralName;
import com.bes.enterprise.cipher.cms.CMSSignedData;
import com.bes.enterprise.cipher.dvcs.CCPDRequestData;
import com.bes.enterprise.cipher.dvcs.CPDRequestData;
import com.bes.enterprise.cipher.dvcs.DVCSConstructionException;
import com.bes.enterprise.cipher.dvcs.DVCSMessage;
import com.bes.enterprise.cipher.dvcs.DVCSRequestData;
import com.bes.enterprise.cipher.dvcs.DVCSRequestInfo;
import com.bes.enterprise.cipher.dvcs.VPKCRequestData;
import com.bes.enterprise.cipher.dvcs.VSDRequestData;

public class DVCSRequest
extends DVCSMessage {
    private com.bes.enterprise.cipher.asn1.dvcs.DVCSRequest asn1;
    private DVCSRequestInfo reqInfo;
    private DVCSRequestData data;

    public DVCSRequest(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance(signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSRequest(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSRequestData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Request");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? com.bes.enterprise.cipher.asn1.dvcs.DVCSRequest.getInstance(contentInfo.getContent()) : com.bes.enterprise.cipher.asn1.dvcs.DVCSRequest.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
        this.reqInfo = new DVCSRequestInfo(this.asn1.getRequestInformation());
        int service = this.reqInfo.getServiceType();
        if (service == ServiceType.CPD.getValue().intValue()) {
            this.data = new CPDRequestData(this.asn1.getData());
        } else if (service == ServiceType.VSD.getValue().intValue()) {
            this.data = new VSDRequestData(this.asn1.getData());
        } else if (service == ServiceType.VPKC.getValue().intValue()) {
            this.data = new VPKCRequestData(this.asn1.getData());
        } else if (service == ServiceType.CCPD.getValue().intValue()) {
            this.data = new CCPDRequestData(this.asn1.getData());
        } else {
            throw new DVCSConstructionException("Unknown service type: " + service);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }

    public DVCSRequestInfo getRequestInfo() {
        return this.reqInfo;
    }

    public DVCSRequestData getData() {
        return this.data;
    }

    public GeneralName getTransactionIdentifier() {
        return this.asn1.getTransactionIdentifier();
    }
}

