/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.dvcs;

import com.bes.enterprise.cipher.asn1.ASN1Encodable;
import com.bes.enterprise.cipher.asn1.ASN1ObjectIdentifier;
import com.bes.enterprise.cipher.asn1.cms.ContentInfo;
import com.bes.enterprise.cipher.asn1.dvcs.DVCSObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.dvcs.DVCSRequestInformationBuilder;
import com.bes.enterprise.cipher.asn1.dvcs.Data;
import com.bes.enterprise.cipher.asn1.x509.ExtensionsGenerator;
import com.bes.enterprise.cipher.asn1.x509.GeneralName;
import com.bes.enterprise.cipher.asn1.x509.GeneralNames;
import com.bes.enterprise.cipher.cms.CMSSignedDataGenerator;
import com.bes.enterprise.cipher.dvcs.DVCSException;
import com.bes.enterprise.cipher.dvcs.DVCSRequest;
import java.io.IOException;
import java.math.BigInteger;

public abstract class DVCSRequestBuilder {
    private final ExtensionsGenerator extGenerator = new ExtensionsGenerator();
    private final CMSSignedDataGenerator signedDataGen = new CMSSignedDataGenerator();
    protected final DVCSRequestInformationBuilder requestInformationBuilder;

    protected DVCSRequestBuilder(DVCSRequestInformationBuilder requestInformationBuilder) {
        this.requestInformationBuilder = requestInformationBuilder;
    }

    public void setNonce(BigInteger nonce) {
        this.requestInformationBuilder.setNonce(nonce);
    }

    public void setRequester(GeneralName requester) {
        this.requestInformationBuilder.setRequester(requester);
    }

    public void setDVCS(GeneralName dvcs) {
        this.requestInformationBuilder.setDVCS(dvcs);
    }

    public void setDVCS(GeneralNames dvcs) {
        this.requestInformationBuilder.setDVCS(dvcs);
    }

    public void setDataLocations(GeneralName dataLocation) {
        this.requestInformationBuilder.setDataLocations(dataLocation);
    }

    public void setDataLocations(GeneralNames dataLocations) {
        this.requestInformationBuilder.setDataLocations(dataLocations);
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws DVCSException {
        try {
            this.extGenerator.addExtension(oid, isCritical, value);
        }
        catch (IOException e) {
            throw new DVCSException("cannot encode extension: " + e.getMessage(), e);
        }
    }

    protected DVCSRequest createDVCRequest(Data data) throws DVCSException {
        if (!this.extGenerator.isEmpty()) {
            this.requestInformationBuilder.setExtensions(this.extGenerator.generate());
        }
        com.bes.enterprise.cipher.asn1.dvcs.DVCSRequest request = new com.bes.enterprise.cipher.asn1.dvcs.DVCSRequest(this.requestInformationBuilder.build(), data);
        return new DVCSRequest(new ContentInfo(DVCSObjectIdentifiers.id_ct_DVCSRequestData, request));
    }
}

