/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.dvcs;

import com.bes.enterprise.cipher.asn1.ASN1Encodable;
import com.bes.enterprise.cipher.asn1.ASN1OctetString;
import com.bes.enterprise.cipher.asn1.ASN1Sequence;
import com.bes.enterprise.cipher.asn1.cms.ContentInfo;
import com.bes.enterprise.cipher.asn1.cms.SignedData;
import com.bes.enterprise.cipher.asn1.dvcs.DVCSObjectIdentifiers;
import com.bes.enterprise.cipher.cms.CMSSignedData;
import com.bes.enterprise.cipher.dvcs.DVCSConstructionException;
import com.bes.enterprise.cipher.dvcs.DVCSMessage;

public class DVCSResponse
extends DVCSMessage {
    private com.bes.enterprise.cipher.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance(signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Response");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? com.bes.enterprise.cipher.asn1.dvcs.DVCSResponse.getInstance(contentInfo.getContent()) : com.bes.enterprise.cipher.asn1.dvcs.DVCSResponse.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

