/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.dvcs;

import com.bes.enterprise.cipher.asn1.dvcs.CertEtcToken;
import com.bes.enterprise.cipher.asn1.dvcs.DVCSRequestInformationBuilder;
import com.bes.enterprise.cipher.asn1.dvcs.DVCSTime;
import com.bes.enterprise.cipher.asn1.dvcs.Data;
import com.bes.enterprise.cipher.asn1.dvcs.ServiceType;
import com.bes.enterprise.cipher.asn1.dvcs.TargetEtcChain;
import com.bes.enterprise.cipher.asn1.x509.Extension;
import com.bes.enterprise.cipher.cert.X509CertificateHolder;
import com.bes.enterprise.cipher.dvcs.DVCSException;
import com.bes.enterprise.cipher.dvcs.DVCSRequest;
import com.bes.enterprise.cipher.dvcs.DVCSRequestBuilder;
import com.bes.enterprise.cipher.dvcs.TargetChain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder cert) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, cert.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date requestTime) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(requestTime));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

