/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.dvcs;

import com.bes.enterprise.cipher.asn1.dvcs.Data;
import com.bes.enterprise.cipher.asn1.dvcs.TargetEtcChain;
import com.bes.enterprise.cipher.dvcs.DVCSConstructionException;
import com.bes.enterprise.cipher.dvcs.DVCSRequestData;
import com.bes.enterprise.cipher.dvcs.TargetChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VPKCRequestData
extends DVCSRequestData {
    private List chains;

    VPKCRequestData(Data data) throws DVCSConstructionException {
        super(data);
        TargetEtcChain[] certs = data.getCerts();
        if (certs == null) {
            throw new DVCSConstructionException("DVCSRequest.data.certs should be specified for VPKC service");
        }
        this.chains = new ArrayList(certs.length);
        for (int i = 0; i != certs.length; ++i) {
            this.chains.add(new TargetChain(certs[i]));
        }
    }

    public List getCerts() {
        return Collections.unmodifiableList(this.chains);
    }
}

